/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.alions;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.utils.LifeCycle;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class AlionsConsumer
extends LifeCycle
implements Consumer {
    private final Properties properties = new Properties();
    private com.aliyun.openservices.ons.api.Consumer consumer;
    private final Listener messageListener;
    private String subExpression;

    public AlionsConsumer(String consumerId, Properties properties, Listener messageListener) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)consumerId));
        Preconditions.checkNotNull((Object)properties);
        Preconditions.checkNotNull((Object)messageListener);
        this.properties.putAll((Map<?, ?>)properties);
        this.properties.put("GROUP_ID", consumerId);
        this.messageListener = messageListener;
    }

    @Override
    protected void doInit() {
        this.consumer = ONSFactory.createConsumer((Properties)this.properties);
        if (null != this.consumer) {
            String topic = this.messageListener.getTopic();
            if (StringUtils.isBlank((String)topic)) {
                throw new RuntimeException("topic must has not blank!");
            }
            if (StringUtils.isBlank((String)this.subExpression)) {
                this.subExpression = "*";
            }
            this.consumer.subscribe(topic, this.subExpression, new MessageListener(){

                public Action consume(com.aliyun.openservices.ons.api.Message message, ConsumeContext context) {
                    Message msg = new Message();
                    msg.setTopic(message.getTopic());
                    msg.setBody(message.getBody());
                    msg.setTags(message.getTag());
                    msg.setKey(message.getKey());
                    msg.setMsgId(message.getMsgID());
                    msg.setReconsumeTimes(message.getReconsumeTimes());
                    Enum status = null;
                    if (AlionsConsumer.this.messageListener instanceof SingleMessageListener) {
                        status = ((SingleMessageListener)AlionsConsumer.this.messageListener).consume(msg, context);
                    }
                    if (null == status) {
                        return Action.ReconsumeLater;
                    }
                    switch (2.$SwitchMap$com$bxm$warcar$mq$ConsumeStatus[status.ordinal()]) {
                        case 1: {
                            return Action.CommitMessage;
                        }
                    }
                    return Action.ReconsumeLater;
                }
            });
            if (this.consumer.isClosed()) {
                this.consumer.start();
            }
        }
    }

    @Override
    protected void doDestroy() {
        this.shutdown();
    }

    @Override
    public void suspend() {
        if (this.consumer.isStarted()) {
            this.consumer.shutdown();
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void start() {
        this.init();
    }

    @Override
    public boolean isStarted() {
        if (null == this.consumer) {
            return false;
        }
        return this.consumer.isStarted();
    }

    public void setSubExpression(String subExpression) {
        this.subExpression = subExpression;
    }

    @Override
    public Listener getMessageListener() {
        return this.messageListener;
    }
}

