/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.redis;

import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendException;
import com.bxm.warcar.mq.SendResult;
import com.bxm.warcar.mq.Type;
import com.bxm.warcar.mq.redis.RedisConst;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisProducer
implements Producer {
    private final JedisPool jedisPool;

    public JedisProducer(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public SendResult send(Message message) throws SendException {
        String topic = message.getTopic();
        String id = UUIDHelper.generate();
        message.setMsgId(id);
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            Long row = jedis.rpush(RedisConst.key(topic), new String[]{JsonHelper.convert(message)});
            if (null != row && row >= 1L) {
                SendResult sendResult = new SendResult(id);
                return sendResult;
            }
        }
        catch (Exception e) {
            throw new SendException(e.getMessage());
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        throw new SendException("0");
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public Type getType() {
        return Type.Redis;
    }
}

