/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.mq.rocketmq;

import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.SendException;
import com.bxm.warcar.mq.SendResult;
import com.bxm.warcar.mq.Type;
import com.bxm.warcar.utils.LifeCycle;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketmqProducer
extends LifeCycle
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(RocketmqProducer.class);
    private final DefaultMQProducer producer;
    private final String nameSrvAddr;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public RocketmqProducer(String nameSrvAddr) {
        this(nameSrvAddr, "producer", new HashMap<String, String>());
    }

    public RocketmqProducer(String nameSrvAddr, String producerGroup, Map<String, String> brokerAddrAlias) {
        this.producer = new DefaultMQProducer(producerGroup);
        this.nameSrvAddr = nameSrvAddr;
        this.producer.setNamesrvAddr(nameSrvAddr);
        this.producer.setBrokerAddrAlias(brokerAddrAlias);
    }

    @Override
    public SendResult send(Message message) throws SendException {
        try {
            org.apache.rocketmq.client.producer.SendResult sendResult;
            org.apache.rocketmq.common.message.Message msg = new org.apache.rocketmq.common.message.Message();
            msg.setTopic(message.getTopic());
            msg.setBody(message.getBody());
            msg.setTags(message.getTags());
            int level = message.getDelayTimeLevel();
            if (level > 0) {
                msg.setDelayTimeLevel(level);
            }
            if (null == (sendResult = this.producer.send(msg))) {
                throw new SendException();
            }
            if (sendResult.getSendStatus() != SendStatus.SEND_OK && log.isWarnEnabled()) {
                log.warn(String.format("Send status unexpected: %s", sendResult.getSendStatus()));
            }
            return new SendResult(sendResult.getMsgId());
        }
        catch (Exception e) {
            throw new SendException(e);
        }
    }

    @Override
    protected void doInit() {
        try {
            this.producer.start();
            this.started.set(true);
        }
        catch (MQClientException e) {
            throw new RuntimeException("doInit:", e);
        }
    }

    @Override
    protected void doDestroy() {
        this.producer.shutdown();
        this.started.set(false);
    }

    @Override
    public void start() {
        this.init();
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public boolean isStarted() {
        return null != this.producer && this.started.get();
    }

    public DefaultMQProducer getProducer() {
        return this.producer;
    }

    public String getNameSrvAddr() {
        return this.nameSrvAddr;
    }

    @Override
    public Type getType() {
        return Type.RocketMq;
    }
}

