/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.utils.http;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static CloseableHttpClient httpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)new BasicCookieStore()).build();

    public static String get(String url) throws IOException {
        return HttpClientUtils.get(url, Maps.newHashMap());
    }

    public static String get(String url, Map<String, String> headers) throws IOException {
        return HttpClientUtils.get(url, Maps.newHashMap(), headers);
    }

    public static String get(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        HttpGet httpGet = new HttpGet(OkHttpUtils.appendParams(url, params));
        HttpClientUtils.setHeader((HttpRequestBase)httpGet, headers);
        return HttpClientUtils.doRequest((HttpRequestBase)httpGet, headers);
    }

    public static String post(String url) throws IOException {
        return HttpClientUtils.post(url, Maps.newHashMap(), Maps.newHashMap());
    }

    public static String post(String url, Map<String, Object> params) throws IOException {
        return HttpClientUtils.post(url, params, Maps.newHashMap());
    }

    public static String post(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        HttpClientUtils.setParams(httpPost, params);
        return HttpClientUtils.doRequest((HttpRequestBase)httpPost, headers);
    }

    public static String postRequestBody(String url, Object o, Map<String, String> headers) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        HttpClientUtils.setRequestBody(httpPost, o);
        return HttpClientUtils.doRequest((HttpRequestBase)httpPost, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doRequest(HttpRequestBase httpRequest, Map<String, String> headers) throws IOException {
        try (CloseableHttpResponse httpResp = null;){
            HttpClientUtils.setHeader(httpRequest, headers);
            httpResp = httpClient.execute((HttpUriRequest)httpRequest);
            String string = EntityUtils.toString((HttpEntity)httpResp.getEntity());
            return string;
        }
    }

    public static void setHeader(HttpRequestBase httpRequest, Map<String, String> headers) {
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void setParams(HttpPost httpPost, Map<String, Object> params) {
        if (MapUtils.isNotEmpty(params)) {
            ArrayList pairs = new ArrayList(params.size());
            params.forEach((key, value) -> pairs.add(new BasicNameValuePair(key, value.toString())));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, Charsets.UTF_8));
        }
    }

    public static void setRequestBody(HttpPost httpPost, Object o) {
        if (null != o) {
            httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)o), ContentType.APPLICATION_JSON));
        }
    }
}

