/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.model.constant;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;

public final class RedisKeyGenerator {
    public static KeyGenerator getFastDailyBudget() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "DAILY_BUDGET", "FAST", DateHelper.format((String)"yyyyMMdd")});
    }

    public static KeyGenerator getCurrentADXUserTicket(String uid, String ticketId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "COUNTER", "CURRENT", uid, ticketId});
    }

    public static KeyGenerator getPanGuRepeatMt(String adxid, String bidid, Integer mt) {
        return () -> KeyBuilder.build((Object[])new Object[]{"PANGU", "REPEAT", "MT", adxid, bidid, mt});
    }

    @Deprecated
    public static KeyGenerator activityJoin(String uid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ACTIVITY", "JOIN", "COUNT", uid});
    }

    public static KeyGenerator hashOverseasClickIdKey(String cashcatClickId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"overseas", "click", cashcatClickId});
    }

    public static KeyGenerator hashEventNameMappingKey() {
        return () -> KeyBuilder.build((Object[])new Object[]{"overseas", "event_name_mapping"});
    }

    public static KeyGenerator hashOverseasConfigKey() {
        return () -> KeyBuilder.build((Object[])new Object[]{"overseas", "feedback_config"});
    }

    public static KeyGenerator strConversionValid(String bxmid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"conversion", "valid", bxmid});
    }

    public static KeyGenerator strQiMaoDeviceClickId(String deviceId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "qimao", "device_click_id", deviceId});
    }

    public static KeyGenerator strAlipaydhIpClickId(String ip) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "alipdh", "ip_click_id", ip});
    }

    public static KeyGenerator strSinaIpUaClickId(String ipUa) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "sina", "ip_ua_click_id", ipUa});
    }

    public static KeyGenerator strFeedbackClickId(String positionId, String clickId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb_control", "click_id", positionId, clickId});
    }
}

