#!/bin/bash

ACTIVE="$1"
if [ -z "$ACTIVE" ]; then
  ACTIVE="production"
  echo "Use default profile: $ACTIVE"
fi
HEAP="$2"
if [ -z "$HEAP" ]; then
  HEAP="2g"
  echo "Use default heap: $HEAP"
fi

[ ! -d ~/run/ ] && mkdir -p ~/run

if [ -f ~/run/adscounter-youku.pid ]; then
  echo "Server [adscounter-youku] pid file has been exists!";
  exit
fi

SERVER_JAR=`ls ../lib/adscounter-youku-1.18.4.jar`

exec "${JAVA_HOME}/bin/java" -server -Dspring.profiles.active=$ACTIVE -Xms$HEAP -Xmx$HEAP -XX:+HeapDumpOnOutOfMemoryError -XX:+UseG1GC -jar ${SERVER_JAR} >/dev/null 2>&1 & echo $! > ~/run/adscounter-youku.pid