package com.bxm.adsfm.facade.service;


import com.bxm.adsfm.facade.concants.AdsFMFacadeConstants;
import com.bxm.adsfm.facade.model.FeatureDto;
import com.bxm.adsfm.facade.model.TicketCTRRO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;


/**
 * Description FM算法相关接口
 *
 * @author lala
 * <p>
 * Date 2019/9/3 17:20
 */
@FeignClient(name = AdsFMFacadeConstants.SERVER_NAME)
public interface FMFacadeService {


    /**
     * 根据参数获取CTR
     * uid为以后使用，不同的uid返回不同的模型
     *
     * @return
     */
    @RequestMapping(value = "/fm/getFMCTR", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    TicketCTRRO getFMByUid(@RequestBody FeatureDto featureDto);

    /**
     * 根据参数获取CTR列表
     *
     * @return
     */
    @RequestMapping(value = "/fm/getFMCTRByList", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    List<TicketCTRRO> getFMCTRByList(@RequestBody List<FeatureDto> featureDtoList);


}
