package com.bxm.adsmanager.facade.model.ticket;

import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.adsmanager.facade.model.base.BaseDto;
import com.bxm.adsmanager.facade.model.base.Money;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;

public class AdTicketDto extends BaseDto {

    private static final long serialVersionUID = -3788641020515414269L;

    private String name;              // name

    private Long advertiser;        // 广告主id // 调广告主接口

    private Short settleType;        // 结算类型1- CPC、2- CPA

    private Double price;             // 单价

    private Short type;              // 广告券类型。1- 常规券、2- 备用券、3- 激励券、4- 券码类

    private Double budgetDaily;       // 日限额（预算），CPC单位是元，CPA单位是张。0 表示无限额。如果是金额，单位：厘

    private String domainCode;        // 所属行业 广告分类 // tbl_ad_domain 调接口 数据采集

    private Double standaloneCost;    // 独立成本。百分比

    private String url;               // 落地页

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validStartDate;    // 有效期开始

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validEndDate;      // 有效期结束

    @Deprecated
    private Short isSupportWechat;   // 是否支持微信。0- 不支持、1- 支持

    /**
     * 投放平台  其他 = 0,微信 = 1, 支付宝 = 2
     */
    private String apps;

    private Integer userGradePassScore;// 用户评分及格分数线

    private Short status;            // 状态。2- 暂停、1- 正常、3 关闭、99 已删除

    private Integer pauseReason;       // 暂停原因。1- 超出预算、2- 余额不足

    private short isEffectMonitor;     //是否接入效果监控; 1-否 2-接入且精确  3-接入但不准

    private short lastStatus;//记录状态修改前的正的状态

    //旧的修改单价
    private Double oldPrice;

    public short getIsEffectMonitor() {
        return isEffectMonitor;
    }

    public void setIsEffectMonitor(short isEffectMonitor) {
        this.isEffectMonitor = isEffectMonitor;
    }

    public short getLastStatus() {
        return lastStatus;
    }

    public void setLastStatus(short lastStatus) {
        this.lastStatus = lastStatus;
    }


    public Double getOldPrice() {
        return oldPrice;
    }

    public void setOldPrice(Double oldPrice) {
        this.oldPrice = oldPrice;
    }


    private String createUser;//创建人

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    /**
     * 广告组ID
     */
    private Boolean isGroup;
    private Long groupId;

    public Boolean getIsGroup() {
        return isGroup == null ? false : isGroup;
    }

    public void setIsGroup(Boolean isGroup) {
        this.isGroup = isGroup;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public boolean flag;

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public boolean isUpdate() {
        return this.flag;
    }

    // 权重
    private Double weight;          // tbl_ad_ticket_weight_manual_conf 1对1

    // 广告素材 调素材添加接口，返回广告券素材列表 传广告素材表id tbl_ad_assets 存入关联表中tbl_ad_ticket_assets_ref
    private String assetsids;

    // 广告标签 tbl_ad_tag 调接口 数据采集
    private String tags;               // 1对多 tbl_ad_rules 1-1-100

    // 区域定向 city=城市 缺城市表，然后写接口调城市列表 调 张凯接口 tbl_ad_rules
    private String citys;           // 1对多 tbl_ad_rules 110000,522501
    private Boolean booleanCitys;

    //区域定向  ipLib=指定ip库
    private String ipLibrary;

    public String getIpLibrary() {
        return ipLibrary;
    }

    public void setIpLibrary(String ipLibrary) {
        this.ipLibrary = ipLibrary;
    }

    // 操作平台 数组 json 格式
    private String oss;             // 1对多 tbl_ad_ticket_os_conf

    // 人群定向 要调个推接口匹配数据 json 格式
    private AdTicketPersonsGradeConf ref;             // tbl_ad_ticket_persons_grade_conf 1对1

    private String personsGradeConf;

    // 投放控制
    private ControlDto controlDto;

    // OCPC
    private OcpcConfDto ocpcConf;

    // 流量包
    //private FlowPackageDto               flowPackageDto;
    /**
     * 流量包ID 为黑白名单而生
     */
    private String flowPackageIdArray;

    /**
     * 流量包信息为限额出价而生
     */
    private String flowPackageArray;

    public String getFlowPackageIdArray() {
        return flowPackageIdArray;
    }

    public void setFlowPackageIdArray(String flowPackageIdArray) {
        this.flowPackageIdArray = flowPackageIdArray;
    }

    public String getFlowPackageArray() {
        return flowPackageArray;
    }

    public void setFlowPackageArray(String flowPackageArray) {
        this.flowPackageArray = flowPackageArray;
    }

    public static class OcpcConfDto {

        private Long ticketId;
        private Short isSupportOcpc;
        private Double cpaExpectPrice;
        private Integer closeThreshold;
        //新增字段 旧的预期cpa-日志记录用
        private Double oldCpaPrice;

        public AdTicketOcpcConf to() {
            AdTicketOcpcConf dest = new AdTicketOcpcConf();
            dest.setCloseThreshold(getCloseThreshold());
            dest.setIsSupportOcpc(getIsSupportOcpc());
            dest.setTicketId(getTicketId());
            Double cpaExpectPrice = getCpaExpectPrice();
            if (null != cpaExpectPrice) {
                dest.setCpaExpectPrice(Long.valueOf(Money.ofYuan(cpaExpectPrice).getLi()).intValue());
            }
            return dest;
        }

        public Long getTicketId() {
            return ticketId;
        }

        public void setTicketId(Long ticketId) {
            this.ticketId = ticketId;
        }

        public Short getIsSupportOcpc() {
            return isSupportOcpc;
        }

        public void setIsSupportOcpc(Short isSupportOcpc) {
            this.isSupportOcpc = isSupportOcpc;
        }

        public Double getCpaExpectPrice() {
            return cpaExpectPrice;
        }

        public void setCpaExpectPrice(Double cpaExpectPrice) {
            this.cpaExpectPrice = cpaExpectPrice;
        }

        public Integer getCloseThreshold() {
            return closeThreshold;
        }

        public void setCloseThreshold(Integer closeThreshold) {
            this.closeThreshold = closeThreshold;
        }

        public Double getOldCpaPrice() {
            return oldCpaPrice;
        }

        public void setOldCpaPrice(Double oldCpaPrice) {
            this.oldCpaPrice = oldCpaPrice;
        }


    }

    public static class ControlDto {

        /**
         * 投放时段 start=开始时间。单位：小时 end=结束时间。单位：小时 limit=限额。金额或张，金额单位：厘
         * 1对多 tbl_ad_rules
         */
        private String times;
        private Boolean booleanTimes;

        /**
         * 广告位定向 先调用查询所有的广告位接口，传参数type=类型。1- 白名单、2- 黑名单position=广告位ID
         * 1对多 tbl_ad_rules
         */
        private String banners;

        /**
         * 未获取到用户imei 是否投放
         * tbl_ad_ticket_onoff
         */
        private String noimei;

        /**
         * 个推imei未匹配是否投放
         * tbl_ad_ticket_onoff
         */
        private String imeinomatching;

        /**
         * 频次控制规则 可以不填 {曝光}cycle=周期->天数 type=类型。1- 曝光、2- 点击count=次数 1-1-100,1-1-101
         * tbl_ad_rules 1对1
         */
        private String frequencys;

        public String getTimes() {
            return times;
        }

        public void setTimes(String times) {
            this.times = times;
        }

        public String getBanners() {
            return banners;
        }

        public void setBanners(String banners) {
            this.banners = banners;
        }

        public String getNoimei() {
            return noimei;
        }

        public void setNoimei(String noimei) {
            this.noimei = noimei;
        }

        public String getImeinomatching() {
            return imeinomatching;
        }

        public void setImeinomatching(String imeinomatching) {
            this.imeinomatching = imeinomatching;
        }

        public String getFrequencys() {
            return frequencys;
        }

        public void setFrequencys(String frequencys) {
            this.frequencys = frequencys;
        }

        public Boolean getBooleanTimes() {
            return booleanTimes == null ? false : booleanTimes;
        }

        public void setBooleanTimes(Boolean booleanTimes) {
            this.booleanTimes = booleanTimes;
        }
    }

    public AdTicketPersonsGradeConf getRef() {
        return ref;
    }

    public void setRef(AdTicketPersonsGradeConf ref) {
        this.ref = ref;
    }

    public String getPersonsGradeConf() {
        return personsGradeConf;
    }

    public void setPersonsGradeConf(String personsGradeConf) {
        this.personsGradeConf = personsGradeConf;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getAdvertiser() {
        return advertiser;
    }

    public void setAdvertiser(Long advertiser) {
        this.advertiser = advertiser;
    }

    public Short getSettleType() {
        return settleType;
    }

    public void setSettleType(Short settleType) {
        this.settleType = settleType;
    }

    public Double getPrice() {
        return price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Double getBudgetDaily() {
        return budgetDaily;
    }

    public void setBudgetDaily(Double budgetDaily) {
        this.budgetDaily = budgetDaily;
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public Double getStandaloneCost() {
        return standaloneCost;
    }

    public void setStandaloneCost(Double standaloneCost) {
        this.standaloneCost = standaloneCost;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }

    public Short getIsSupportWechat() {
        return isSupportWechat;
    }

    public void setIsSupportWechat(Short isSupportWechat) {
        this.isSupportWechat = isSupportWechat;
    }

    public Integer getUserGradePassScore() {
        return userGradePassScore;
    }

    public void setUserGradePassScore(Integer userGradePassScore) {
        this.userGradePassScore = userGradePassScore;
    }

    public Short getStatus() {
        return status;
    }

    /* // 老系统只有开启和关闭的
     public Integer getOldStatus() {
         if (AdTicket.STATUS_CLOSE == status || AdTicket.STATUS_DELETED == status) {
             return 0;
         }
         return 1;
     }
  */
    public void setStatus(Short status) {
        this.status = status;
    }

    public Integer getPauseReason() {
        return pauseReason;
    }

    public void setPauseReason(Integer pauseReason) {
        this.pauseReason = pauseReason;
    }

    public String getAssetsids() {
        return assetsids;
    }

    public void setAssetsids(String assetsids) {
        this.assetsids = assetsids;
    }

    public ControlDto getControlDto() {
        return controlDto;
    }

    public void setControlDto(ControlDto controlDto) {
        this.controlDto = controlDto;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getCitys() {
        return citys;
    }

    public void setCitys(String citys) {
        this.citys = citys;
    }

    public String getOss() {
        return oss;
    }

    // 传过来白名单1,2,4 转老系统的黑名单 取非 4对应3
    public String getOldOss() {
        String temp = "1,2,3";
        if (StringUtils.isNotBlank(oss)) {
            if (oss.equals("1,2,4")) {
                return null;
            }
            for (String s : Splitter.on(",").trimResults().split(oss)) {
                if ("4".equals(s)) {
                    temp = temp.replace("3", "");
                } else {
                    temp = temp.replace(s, "");
                }
            }

            temp = Joiner.on(",").join(Splitter.on(",").omitEmptyStrings().split(temp));
        }
        return temp;
    }

    public void setOss(String oss) {
        this.oss = oss;
    }

    public Double getWeight() {
        return weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public interface Add {
    }

    public interface Update {
    }

    public OcpcConfDto getOcpcConf() {
        return ocpcConf;
    }

    public void setOcpcConf(OcpcConfDto ocpcConf) {
        this.ocpcConf = ocpcConf;
    }

    public static class FlowPackageDto {

        private String flowPackageIdsAndQuota; // 流量包id和限制额度格式位（id-额度,id-额度） 

        public String getFlowPackageIdsAndQuota() {
            return flowPackageIdsAndQuota;
        }

        public void setFlowPackageIdsAndQuota(String flowPackageIdsAndQuota) {
            this.flowPackageIdsAndQuota = flowPackageIdsAndQuota;
        }
    }

//    public FlowPackageDto getFlowPackageDto() {
//        return flowPackageDto;
//    }
//
//    public void setFlowPackageDto(FlowPackageDto flowPackageDto) {
//        this.flowPackageDto = flowPackageDto;
//    }

    public Boolean getBooleanCitys() {
        return booleanCitys == null ? false : booleanCitys;
    }

    public void setBooleanCitys(Boolean booleanCitys) {
        this.booleanCitys = booleanCitys;
    }

    private String log;

    public String getLog() {
        return log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    private String ae;

    public String getAe() {
        return ae;
    }

    public void setAe(String ae) {
        this.ae = ae;
    }

    public String getApps() {
        return apps;
    }

    public void setApps(String apps) {
        this.apps = apps;
    }
}
