package com.bxm.adsmanager.facade.service;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.warcar.utils.response.ResultModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
/**
 * @author wangchao
 * @description 其他接口
 * @date 2019/04/09 11:23
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdsmanagerFacadeService {

    @RequestMapping("/adsmanager/findPositionProfit")
    ResultModel findPositionProfit(@RequestParam(name = "appKey") String appKey,
                                   @RequestParam(name = "datetime", required = false) String datetime);


    @RequestMapping(value = "/adsmanager/positionSizePush", method = RequestMethod.GET)
    void pushPositionSize(@RequestParam(name = "positionSize") String positionSize,
                          @RequestParam(name = "positionId") String positionId);
}
