package com.bxm.adsmanager.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.adsmanager.facade.constant.Constants;
import com.bxm.adsmanager.facade.model.position.Position;
import com.bxm.adsmanager.facade.model.ticket.AdTicketCostLog;
import com.bxm.adsmanager.facade.model.ticket.TicketProfitForCpa;
import com.bxm.warcar.utils.response.ResultModel;

/**
 * @author wangchao
 * @description 券相关接口
 * @date 2019/04/09 16:00
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdsprodTicketFacadeService {

    @RequestMapping(value = "/adsmanager/updateAdTicket", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel update(@RequestParam(required = true, name = "id") Long id,
                       @RequestParam(required = true, name = "reason") Integer reason,
                       @RequestParam(required = true, name = "status") Short status);


    @RequestMapping(value = "/adsmanager/plusAdvertiserBalance",method = RequestMethod.GET,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<Long> plusAdvertiserBalance(@RequestParam("id") Long id, @RequestParam("value") Long value);


    @RequestMapping(value = "/adsmanager/pushCpaProfitData", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<?> pushCpaProfitData(@RequestBody List<TicketProfitForCpa> data);

    @RequestMapping(value = "/adsmanager/pushPosition/{id}", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel<?> pushPosition(@PathVariable("id") String positionId,
                                @RequestBody Position position);

    @RequestMapping(value = "/adsmanager/addTicketCostLog", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel addTicketCostLog(@RequestBody AdTicketCostLog adTicketCostLog);


    /**
     * 更新优惠券码的信息
     * @param ticketId
     * @param status
     * @param firstShowTime
     * @param useTime
     * @param usePositionId
     * @param bindDeviceNo
     * @param couponsCode
     * @return
     */
    @RequestMapping(value = "/adsmanager/updateTicketCouponsCode", method = RequestMethod.POST,consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResultModel updateTicketCouponsCode(@RequestParam(required = true, name = "ticketId") Long ticketId,
                                        @RequestParam(required = true, name = "status") Short status,
                                        @RequestParam(required = false, name = "firstShowTime") Long firstShowTime,
                                        @RequestParam(required = false, name = "useTime") Long useTime,
                                        @RequestParam(required = true, name = "usePositionId") String usePositionId,
                                        @RequestParam(required = true, name = "bindDeviceNo") String bindDeviceNo,
                                        @RequestParam(required = true, name = "couponsCode") String couponsCode);

}
