/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmedia.common.util;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmedia.common.util.RandomUtil;
import com.bxm.warcar.utils.response.ResultModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public final class CaptchaImgCreator {
    private int width;
    private int height;
    private int interferenceLineNum;
    private String customCaptcha;

    private CaptchaImgCreator() {
    }

    private CaptchaImgCreator(int width, int height, int interferenceLineNum, String customCaptcha) {
        this.width = width;
        this.height = height;
        this.interferenceLineNum = interferenceLineNum;
        this.customCaptcha = customCaptcha;
    }

    public static CaptchaImgCreator instance(String captcha) {
        if (StringUtils.isBlank((CharSequence)captcha)) {
            throw new NullPointerException("captcha is null!");
        }
        return new CaptchaImgCreator(200, 80, 20, captcha);
    }

    private Color createsRandomColor() {
        int r = new Double(Math.random() * 256.0).intValue();
        int g = new Double(Math.random() * 256.0).intValue();
        int b = new Double(Math.random() * 256.0).intValue();
        return new Color(r, g, b);
    }

    private void drawGraphic(BufferedImage image) {
        int i;
        String random = this.customCaptcha;
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.getRandColor(200, 250));
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setFont(new Font("arial", 1, 60));
        for (i = 0; i < random.length(); ++i) {
            char str = random.charAt(i);
            graphics.setColor(this.createsRandomColor());
            graphics.drawString(str + "", i * 50, 65);
        }
        if (this.createInterferenceLineFlag().booleanValue()) {
            for (i = 0; i < this.interferenceLineNum; ++i) {
                graphics.drawLine(RandomUtil.getRandomNum(this.width), RandomUtil.getRandomNum(this.height), RandomUtil.getRandomNum(this.width), i);
            }
        }
        graphics.dispose();
    }

    private Boolean createInterferenceLineFlag() {
        return this.interferenceLineNum > 0;
    }

    private Color getRandColor(int lower, int upper) {
        Random random = new Random();
        if (upper > 255) {
            upper = 255;
        }
        if (upper < 1) {
            upper = 1;
        }
        if (lower < 1) {
            lower = 1;
        }
        if (lower > 255) {
            lower = 255;
        }
        int r = lower + random.nextInt(upper - lower);
        int g = lower + random.nextInt(upper - lower);
        int b = lower + random.nextInt(upper - lower);
        return new Color(r, g, b);
    }

    public void writeImg(HttpServletResponse response) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        this.drawGraphic(image);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        ServletOutputStream sos = null;
        try {
            sos = response.getOutputStream();
            ImageIO.write((RenderedImage)image, "jpeg", (OutputStream)sos);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (sos != null) {
                try {
                    sos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void sendErrorMsg(HttpServletResponse response, String errorMsg) throws IOException {
        ResultModel result = new ResultModel();
        result.setSuccessed(false);
        result.setErrorDesc(errorMsg);
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        String json = JSONObject.toJSONString((Object)result);
        out.print(json);
        out.flush();
    }
}

