package com.bxm.adsmedia.common.context.user;

import com.bxm.adsmedia.common.entity.RequestInfo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Description TODO
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/16 15:27
 */
public class RequestInfoContext {

    private final static ThreadLocal<RequestInfo> CONTEXT = new ThreadLocal<>();

    public static void setContext(RequestInfo requestInfo) {
        CONTEXT.set(requestInfo);
    }

    public static void remove() {
        CONTEXT.remove();
    }

    public static RequestInfo get() {
        return CONTEXT.get();
    }

    public static HttpServletResponse getResponse() {
        return CONTEXT.get().getResponse();
    }

    public static HttpServletRequest getRequest() {
        return CONTEXT.get().getRequest();
    }

    public static HttpSession getSession() {
        return CONTEXT.get().getRequest().getSession();
    }

}
