package com.bxm.adsmedia.common.context.user;

import com.bxm.adsmedia.common.entity.User;
import com.bxm.adsmedia.common.exception.AuthException;
import lombok.extern.slf4j.Slf4j;

/**
 * Description 当前登录人信息的全局变量
 *
 * @author hxpeng
 * <p>
 * Date 2019/1/15 20:49
 */
@Slf4j
public class UserSessionContext {

    private final static ThreadLocal<User> CONTEXT = new ThreadLocal<>();

    public static void setContext(User user) {
        CONTEXT.set(user);
    }

    public static void remove() {
        CONTEXT.remove();
    }

    public static User get() {
        return CONTEXT.get();
    }

    private static User getCurrentUser() {
        User user = CONTEXT.get();
        if (null == user) {
            log.warn("检查下权限 --> ");
            throw new AuthException();
        }
        return user;
    }

    /**
     * Description: 获取当前登录人ID
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/15 21:15
     *
     * @return java.lang.Long
     * @author hxpeng
     */
    public static Long getProviderId() {
        return getCurrentUser().getId();
    }

    /**
     * Description: 获取当前登录用户的手机号码
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 20:58
     *
     * @return java.lang.String
     * @author hxpeng
     */
    public static String getPhoneNum() {
        return getCurrentUser().getPhoneNum();
    }

    /**
     * Description: 获取当前会话token
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/15 22:05
     *
     * @return java.lang.String
     * @author hxpeng
     */
    public static String getToken() {
        return getCurrentUser().getToken();
    }

    /**
     * Description: 获取开发者名称 （等于之前的APP_NAME名称）
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/15 22:05
     *
     * @return java.lang.String
     * @author hxpeng
     */
    public static String getProviderName() {
        return getCurrentUser().getProviderName();
    }

    /**
     * Description: 是否已登录
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 21:04
     *
     * @return java.lang.Boolean
     * @author hxpeng
     */
    public static Boolean hasLogged() {
        return null != get();
    }

    /**
     * Description: 获取appkey
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 21:04
     *
     * @return java.lang.Boolean
     * @author hxpeng
     */
    public static String getAppKey() {
        return getCurrentUser().getAppKey();
    }
}
