package com.bxm.adsmedia.common.util;

import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.utils.response.ResultModel;
import org.apache.commons.lang3.StringUtils;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;

/**
 * 类CreateValidateCode.java的实现描述：生成验证码
 *
 * @author yangdong 2015年7月14日 上午9:37:56
 */
public final class CaptchaImgCreator {

    /**
     * 宽 / 高 / 干扰线数量
     */
    private int width;
    private int height;
    private int interferenceLineNum;

    /**
     * 自定验证码
     */
    private String customCaptcha;

    private CaptchaImgCreator() {
    }

    private CaptchaImgCreator(int width, int height, int interferenceLineNum, String customCaptcha) {
        this.width = width;
        this.height = height;
        this.interferenceLineNum = interferenceLineNum;
        this.customCaptcha = customCaptcha;
    }

    public BufferedImage getBufferedImage () {
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        String random = customCaptcha;
        // 创建绘画图像
        Graphics graphics = image.getGraphics();
        // 指定绘图颜色
        graphics.setColor(getRandColor(200, 250));
        // 填充矩形 （相当于刷背景色）
        graphics.fillRect(0, 0, width, height);
        // 指定绘图字体
        graphics.setFont(new Font("arial", Font.BOLD, 60));
        // 使用DarwXXX的方法实现绘制
        for (int i = 0; i < random.length(); i++) {
            char str = random.charAt(i);
            graphics.setColor(createsRandomColor());
            graphics.drawString(str + "", i * 50, 65);
        }
        // 实现干扰线效果
        if (createInterferenceLineFlag()) {
            for (int i = 0; i < interferenceLineNum; i++) {
                // 线条坐标 this.getRandomNum(height),
                graphics.drawLine(RandomUtil.getRandomNum(width), RandomUtil.getRandomNum(height), RandomUtil.getRandomNum(width), i);
            }
        }
        // 图象生效
        graphics.dispose();
        return image;
    }

    /**
     * Description: 创建验证码生成类
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 11:02
     *
     * @return com.bxm.adsmedia.common.util.CaptchaImgCreator
     * @author hxpeng
     */
    public static CaptchaImgCreator instance(String captcha) {
        if (StringUtils.isBlank(captcha)) {
            throw new NullPointerException("captcha is null!");
        }
        return new CaptchaImgCreator(200, 80, 20, captcha);
    }

    /**
     * Description: 随机产生一个颜色
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 10:29
     *
     * @return java.awt.Color
     * @author hxpeng
     */
    private Color createsRandomColor() {
        int r = (new Double(Math.random() * 256)).intValue();
        int g = (new Double(Math.random() * 256)).intValue();
        int b = (new Double(Math.random() * 256)).intValue();
        return new Color(r, g, b);
    }

    /**
     * Description: 生成一个内存图片，将四个随机数写在图片上
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 10:38
     *
     * @param image image
     * @return java.lang.String
     * @author hxpeng
     */
    private void drawGraphic(BufferedImage image) {
        String random = this.customCaptcha;
        // 创建绘画图像
        Graphics graphics = image.getGraphics();
        // 指定绘图颜色
        graphics.setColor(getRandColor(200, 250));
        // 填充矩形 （相当于刷背景色）
        graphics.fillRect(0, 0, width, height);
        // 指定绘图字体
        graphics.setFont(new Font("arial", Font.BOLD, 60));
        // 使用DarwXXX的方法实现绘制
        for (int i = 0; i < random.length(); i++) {
            char str = random.charAt(i);
            graphics.setColor(this.createsRandomColor());
            graphics.drawString(str + "", i * 50, 65);
        }
        // 实现干扰线效果
        if (this.createInterferenceLineFlag()) {
            for (int i = 0; i < this.interferenceLineNum; i++) {
                // 线条坐标 this.getRandomNum(height),
                graphics.drawLine(RandomUtil.getRandomNum(width), RandomUtil.getRandomNum(height), RandomUtil.getRandomNum(width), i);
            }
        }
        // 图象生效
        graphics.dispose();
    }

    /**
     * Description: 是否创建干扰线
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/16 10:57
     *
     * @return java.lang.Boolean
     * @author hxpeng
     */
    private Boolean createInterferenceLineFlag() {
        return this.interferenceLineNum > 0;
    }

    /**
     * 方法说明：随机获取一种颜色
     *
     * @param lower
     * @param upper
     * @return Color
     * @time 2015年8月15日 下午12:23:47
     * @author yangdong
     */
    private Color getRandColor(int lower, int upper) {
        Random random = new Random();
        if (upper > 255) {
            upper = 255;
        }
        if (upper < 1) {
            upper = 1;
        }
        if (lower < 1) {
            lower = 1;
        }
        if (lower > 255) {
            lower = 255;
        }
        int r = lower + random.nextInt(upper - lower);
        int g = lower + random.nextInt(upper - lower);
        int b = lower + random.nextInt(upper - lower);
        return new Color(r, g, b);
    }

    public void writeImg(HttpServletResponse response) {
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        // 生成图片
        drawGraphic(image);
        // 写出图片
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0);
        response.setContentType("image/jpeg");
        ServletOutputStream sos = null;
        try {
            sos = response.getOutputStream();
            ImageIO.write(image, "jpeg", sos);
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            if (sos != null) {
                try {
                    sos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void sendErrorMsg(HttpServletResponse response, String errorMsg) throws IOException {
        ResultModel result = new ResultModel();
        result.setSuccessed(false);
        result.setErrorDesc(errorMsg);
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        String json = JSONObject.toJSONString(result);
        out.print(json);
        out.flush();
    }

}
