package com.bxm.adsmedia.common.util;

import java.util.Random;

/**
 * 类RandomUtil.java的实现描述:生成随机数
 *
 * @author leon 2016年8月11日 下午12:52:51
 */
public class RandomUtil {

    // 定义验证码所取值
    private static final String VALIDATE_CODE_VALUE = "qazwsxedcrfvtgbyhnujmkpQWERTYUIPLKJHGFDSAZXCVBNM123456789";
    // 随机数
    private static final String NUMBER_VALUE = "0123456789";

    /**
     * 方法实现描述:生成随机数
     *
     * @param maxNumber 最大数
     * @return int
     * @author leon 2016年8月11日下午12:54:36
     */
    public static int getRandomNum(int maxNumber) {
        Random random = new Random();
        return random.nextInt(maxNumber);
    }

    /**
     * 方法实现描述:生成随机码(包含字母)
     *
     * @param codeLength 生成的长度
     * @return String
     * @author leon 2016年8月11日下午12:54:50
     */
    public static String getRandomCode(int codeLength) {
        // 定义验证码所取值
        StringBuilder strCode = new StringBuilder();
        // 生成四位数随机验证码内容
        for (int i = 0; i < codeLength; i++) {
            strCode.append(VALIDATE_CODE_VALUE.charAt(getRandomNum(VALIDATE_CODE_VALUE.length())));
        }
        return strCode.toString();
    }

    /**
     * 方法实现描述:生成随机数（纯数字）
     *
     * @param numberLength 随机数位数
     * @return String
     * @author leon 2016年8月11日下午12:55:02
     */
    public static String getRandom(int numberLength) {
        // 定义验证码所取值
        StringBuilder strCode = new StringBuilder();
        // 生成四位数随机验证码内容
        for (int i = 0; i < numberLength; i++) {
            strCode.append(NUMBER_VALUE.charAt(getRandomNum(NUMBER_VALUE.length())));
        }
        return strCode.toString();
    }

}
