/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmedia.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;

public class BianXianMaoSignUtil {
    private static final String APP_SECRET = "appSecret";
    private static final String SIGN = "sign";
    private static final String TIMESTAMP = "timestamp";
    private static final Long EXPIRES_SECOND = 10L;

    public static String md5(String inStr) {
        try {
            return DigestUtils.md5Hex((byte[])inStr.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef");
        }
    }

    public static String sign(HashMap<String, String> params, String appSecret) {
        StringBuilder valueSb = new StringBuilder();
        params.put(APP_SECRET, appSecret);
        TreeMap<String, String> sortParams = new TreeMap<String, String>(params);
        Set entrys = sortParams.entrySet();
        for (Map.Entry entry : entrys) {
            String value = (String)entry.getValue();
            if (value == null || "".equals(value)) continue;
            valueSb.append(value);
        }
        params.remove(APP_SECRET);
        return BianXianMaoSignUtil.md5(valueSb.toString());
    }

    public static boolean verify(String appSecret, HttpServletRequest request) throws Exception {
        String sign = request.getParameter(SIGN);
        if (sign == null || "".equals(sign)) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u5fc5\u987b\u5e26\u7b7e\u540d\u53c2\u6570\uff0c\u4e14\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String timestamp = request.getParameter(TIMESTAMP);
        if (timestamp == null || "".equals(timestamp)) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u5fc5\u987b\u5e26\u65f6\u95f4\u6233\u53c2\u6570\uff0c\u4e14\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long second = null;
        try {
            second = (System.currentTimeMillis() - Long.parseLong(timestamp)) / 60000L;
        }
        catch (Exception e) {
            throw new Exception("\u65f6\u95f4\u6233\u53c2\u6570\u5fc5\u987b\u4e3a13\u4f4d\u6570\u5b57");
        }
        if (second > EXPIRES_SECOND) {
            throw new Exception("timestamp\u6709\u6548\u671f\u8d85\u8fc7\u5341\u5206\u949f");
        }
        HashMap<String, String> params = new HashMap<String, String>(10);
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paramName = ((String)enu.nextElement()).trim();
            params.put(paramName, URLDecoder.decode(request.getParameter(paramName), "UTF-8"));
        }
        params.remove(SIGN);
        return BianXianMaoSignUtil.verify(params, sign, appSecret);
    }

    public static boolean verify(HashMap<String, String> params, String sign, String appSecret) throws Exception {
        if (sign == null || "".equals(sign)) {
            throw new Exception("\u8bf7\u6c42\u4e2d\u5fc5\u987b\u5e26\u7b7e\u540d\u53c2\u6570\uff0c\u4e14\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.put(APP_SECRET, appSecret);
        TreeMap<String, String> sortParams = new TreeMap<String, String>(params);
        Set entrys = sortParams.entrySet();
        StringBuilder valueSb = new StringBuilder();
        for (Map.Entry entry : entrys) {
            String value = (String)entry.getValue();
            if (value == null || "".equals(value)) continue;
            valueSb.append(value);
        }
        return sign.equals(BianXianMaoSignUtil.md5(valueSb.toString()));
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("date", "2022-01-13");
        map.put("appKey", "722928e2c525490aa0b17265dfabd4a3");
        long currentTimeMillis = System.currentTimeMillis();
        currentTimeMillis = 1596676932762L;
        System.out.println(currentTimeMillis);
        map.put(TIMESTAMP, Objects.toString(currentTimeMillis));
        map.put("positionCode", "000480-1");
        String appSecret = "ff1109851ff34deaa0046cfcee1694ce";
        System.out.println(BianXianMaoSignUtil.sign(map, appSecret));
        String sign = "726b03cc2d26ed71df2576bb55959200";
        System.out.println(BianXianMaoSignUtil.verify(map, sign, appSecret));
    }
}

