package com.bxm.adsprod.counter.event.listeners;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.common.eventbus.EventListener;
import com.bxm.adsprod.counter.event.BalanceNotEnoughEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.math.BigInteger;
import java.util.List;

/**
 * 广告主余额不足事件。对该广告主所属的所有广告券进行状态变更。
 * @author allen
 * @since V1.0.0 2017/12/15
 */
@Component
public class BalanceNotEnoughEventListener implements EventListener<BalanceNotEnoughEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(BalanceNotEnoughEventListener.class);

    @Reference(version = "1.0.0")
    private TicketService ticketService;

    @Override
    @Subscribe
    public void consume(BalanceNotEnoughEvent event) {
        Ticket ticket = event.getTicket();

        BigInteger advertiser = ticket.getAdvertiser();
        List<Ticket> allTickets = ticketService.getAllTickets();
        for (Ticket e : allTickets) {
            boolean isSameAdvertiser = null != e.getAdvertiser() && e.getAdvertiser().equals(advertiser);
            if (isSameAdvertiser && e.isAvailableForStatus()) {
                BigInteger id = e.getId();
                boolean flag = ticketService.updateTicketStatus(id, Ticket.STATUS_PAUSE, Ticket.PAUSE_REASON_BALANCE_NOT_ENOUGHT);

                if (flag) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("广告券({})状态(暂停-余额不足)更新完成", id);
                    }
                }
                else {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("广告券({})状态(暂停-余额不足)更新失败!", id);
                    }
                }
            }
        }
    }
}
