package com.bxm.adsprod.counter.ticket;

import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.math.BigInteger;

/**
 * <h3>点击次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
@EnableConfigurationProperties(Configuration.class)
public abstract class AbstractClickCounter extends AbstractCounter<ClickRequest, Ticket> {

    @Autowired
    protected Configuration local;

    @Override
    protected ClickRequest convertRequest(Object request) {
        return (ClickRequest) request;
    }

    @Override
    protected Ticket convertReturning(Object returning) {
        return (Ticket) returning;
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        return DEFAULT_INCREMENT_VALUE;
    }

    @Override
    protected String getUid(ClickRequest clickRequest, Ticket ticket) {
        return clickRequest.getUid();
    }

    @Override
    protected BigInteger getTicketId(ClickRequest clickRequest, Ticket ticket) {
        return ticket.getId();
    }

    @Override
    public String getTopic() {
        return local.getTopic().getClick();
    }

}
