package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.counter.ticket.counter.utils.CounterUtils;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>CPA 广告券每小时预算统计器</h3>
 * <p>当该广告券的时间段预算不足时，会将该广告券的状态更新为暂停</p>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
@Component
@EnableConfigurationProperties({AlionsConfiguration.class, Configuration.class})
public class TicketForCpaHourlyBudgetCounter extends AbstractViewCounter implements HashCounter {

    @Autowired
    private AlionsConfiguration configuration;
    @Autowired
    private Configuration local;
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private EventPark eventPark;
    @Reference(version = "1.0.0")
    private TicketStatisticsService ticketStatisticsService;

    @Override
    public String getField(String uid, BigInteger ticketId) {
        return String.valueOf(ticketId);
    }

    @Override
    protected long getIncrementValue(ViewRequest ticketRequest, Ticket ticket) {
        return ticket.isCPC() ? 0 : DEFAULT_INCREMENT_VALUE;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfHourly();
    }

    @Override
    protected void afterIncrement(long val, ViewRequest viewRequest, Ticket ticket) {
        CounterUtils.doBudgetOfHourly(this, ticketStatisticsService, fetcher, eventPark, ticket);
    }

    @Bean
    public Consumer ticketForCpaHourlyBudgetCounterConsumer() {
        return createConsumer(local.getConsumer().getTicketCpaHourlyBudget(),
                configuration.getAccessKey(), configuration.getSecretKey());
    }
}
