package com.bxm.adsprod.counter.ticket.recorder;

import com.bxm.adsprod.common.message.AbstractMessageListener;
import com.bxm.adsprod.counter.configure.Configuration;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * <h3>用户最后获得的广告券记录器</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Component
@EnableConfigurationProperties({AlionsConfiguration.class, Configuration.class})
public class UserLastTicketRecorder extends AbstractMessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserLastTicketRecorder.class);
    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;
    @Autowired
    private AlionsConfiguration alionsConfiguration;
    @Autowired
    private Configuration local;

    protected void consume(Message message, ViewRequest request, Ticket ticket) {
        setLastAcquireTicket(ticket, request.getUid());
    }

    @Override
    protected void consume(Message message, Object request, Object returning) {
        consume(message, (ViewRequest) request, (Ticket) returning);
    }

    @Override
    public String getTopic() {
        return local.getTopic().getView();
    }

    @Bean
    public Consumer userLastTicketRecoderConsumer() {
        return createConsumer(local.getConsumer().getTicketUserLastRecorder(),
                alionsConfiguration.getAccessKey(), alionsConfiguration.getSecretKey());
    }

    private void setLastAcquireTicket(Ticket ticket, String uid) {
        if (null == ticket) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("inspectors is null.");
            }
            return;
        }
        if (StringUtils.isBlank(uid)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("uid is null.");
            }
            return;
        }
        updater.update(TicketKeyGenerator.User.getUser(uid), ticket, TypeHelper.castToInt(DateHelper.getRemainSecondsOfToday()));
    }
}
