/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.autoconfigure.mongodb;

import com.mongodb.MongoClientURI;
import com.mongodb.ReadPreference;
import java.net.UnknownHostException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
@EnableConfigurationProperties(value={com.bxm.adsprod.counter.properties.Configuration.class})
public class MongoAutoConfiguration {
    private final com.bxm.adsprod.counter.properties.Configuration configuration;

    public MongoAutoConfiguration(com.bxm.adsprod.counter.properties.Configuration configuration) {
        this.configuration = configuration;
    }

    @Bean
    public MongoMappingContext mongoMappingContext3() {
        return new MongoMappingContext();
    }

    @Bean
    public MappingMongoConverter mappingMongoConverter3() throws Exception {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.dbFactory3());
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.mongoMappingContext3());
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        return converter;
    }

    @Bean
    public MongoDbFactory dbFactory3() throws UnknownHostException {
        return new SimpleMongoDbFactory(new MongoClientURI(this.configuration.getMongo().getUrl()));
    }

    @Bean
    public MongoTemplate mongoTemplate3() throws Exception {
        MongoTemplate mongoTemplate = new MongoTemplate(this.dbFactory3(), (MongoConverter)this.mappingMongoConverter3());
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return mongoTemplate;
    }
}

