/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket;

import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.message.AbstractMessageListener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractCounter<REQUEST, RETURNING>
extends AbstractMessageListener {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractCounter.class);
    protected static final long DEFAULT_INCREMENT_VALUE = 1L;
    @Autowired
    @Qualifier(value="jedisCounter")
    protected Counter counter;

    protected abstract REQUEST convertRequest(Object var1);

    protected abstract RETURNING convertReturning(Object var1);

    protected abstract KeyGenerator getKeyGenerator(String var1, BigInteger var2);

    protected KeyGenerator getKeyGenerator(REQUEST request, RETURNING returning) {
        return null;
    }

    protected abstract long getIncrementValue(REQUEST var1, RETURNING var2);

    protected abstract String getUid(REQUEST var1, RETURNING var2);

    protected abstract BigInteger getTicketId(REQUEST var1, RETURNING var2);

    protected int getExpireTimeInSeconds() {
        return TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfDay((int)10));
    }

    protected void beforeIncrement(long val, REQUEST request, RETURNING returning) {
    }

    protected void afterIncrement(long val, REQUEST request, RETURNING returning) {
    }

    protected boolean isIncrementIfNeeded(REQUEST request, RETURNING returning) {
        return true;
    }

    protected final void consume(Message message, Object request, Object returning) {
        REQUEST r = this.convertRequest(request);
        RETURNING rtn = this.convertReturning(returning);
        long incrementValue = this.getIncrementValue(r, rtn);
        String uid = this.getUid(r, rtn);
        BigInteger ticketId = this.getTicketId(r, rtn);
        this.beforeIncrement(incrementValue, r, rtn);
        Long rst = 0L;
        if (this.isIncrementIfNeeded(r, rtn)) {
            KeyGenerator keyGenerator = this.getKeyGenerator(r, rtn);
            if (null == keyGenerator) {
                keyGenerator = this.getKeyGenerator(uid, ticketId);
            }
            rst = this.increment(keyGenerator, r, incrementValue);
        }
        this.afterIncrement(rst, r, rtn);
    }

    private Long increment(KeyGenerator keyGenerator, REQUEST r, long inc) {
        if (this instanceof HashCounter && r instanceof CounterRequest) {
            String field = ((HashCounter)((Object)this)).getField((CounterRequest)r);
            return this.counter.hincrementByAndGet(keyGenerator, field, inc, this.getExpireTimeInSeconds());
        }
        return this.counter.incrementByAndGet(keyGenerator, inc, this.getExpireTimeInSeconds());
    }
}

