/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket;

import com.bxm.adsprod.counter.properties.ConsumerConfiguration;
import com.bxm.adsprod.counter.ticket.ShutdownConsumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.mq.SingleMessageListener;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsPropsConfiguration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={com.bxm.adsprod.counter.properties.Configuration.class, AlionsPropsConfiguration.class})
public class ConsumerAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerAutoConfiguration.class);
    private final AlionsPropsConfiguration alionsPropsConfiguration;
    private final ConsumerConfiguration consumer;

    public ConsumerAutoConfiguration(com.bxm.adsprod.counter.properties.Configuration configuration, AlionsPropsConfiguration alionsPropsConfiguration) {
        this.alionsPropsConfiguration = alionsPropsConfiguration;
        this.consumer = configuration.getConsumer();
    }

    @Bean(initMethod="init")
    public ShutdownConsumer advertiserCashierConsumer(@Qualifier(value="remoteAdvertiserCashier") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getAdvertiserCashier(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer userLastTicketRecoderConsumer(@Qualifier(value="userLastTicketRecorder") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketUserLastRecorder(), messageListener);
    }

    @Deprecated
    public ShutdownConsumer ticketClickCounterConsumer(@Qualifier(value="ticketClickCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketClick(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketDailyClickCounterConsumer(@Qualifier(value="ticketDailyClickCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketDailyClick(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketDailyViewCounterConsumer(@Qualifier(value="ticketDailyViewCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketDailyView(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketCpaDailyBudgetCounterConsumer(@Qualifier(value="ticketForCpaDailyBudgetCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketCpaDailyBudget(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketForCpaHourlyBudgetCounterConsumer(@Qualifier(value="ticketForCpaHourlyBudgetCounter") SingleMessageListener messasgeListener) {
        return this.createConsumer(this.consumer.getTicketCpaHourlyBudget(), messasgeListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketCpcDailyBudgetCounterConsumer(@Qualifier(value="ticketForCpcDailyBudgetCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketCpcDailyBudget(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketForCpcHourlyBudgetCounterConsumer(@Qualifier(value="ticketForCpcHourlyBudgetCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketCpcHourlyBudget(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketHourlyViewCounterConsumer(@Qualifier(value="ticketHourlyViewCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketHourlyView(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketOcpcClickCounterConsumer(@Qualifier(value="ticketOcpcClickCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketOcpcClick(), messageListener);
    }

    @Deprecated
    public ShutdownConsumer ticketOcpcClickWindowedCounterConsumer(@Qualifier(value="ticketOcpcClickWindowedCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketOcpcWindowedClick(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketUserDailyClickCounterConsumer(@Qualifier(value="ticketUserDailyClickCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketUserDailyClick(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketUserDailyViewCounterConsumer(@Qualifier(value="ticketUserDailyViewCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketUserDailyView(), messageListener);
    }

    @Deprecated
    public ShutdownConsumer ticketViewCountConsumer(@Qualifier(value="ticketViewCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketView(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketGroupDailyClickCounterConsumer(@Qualifier(value="ticketGroupDailyClickCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketGroupUserDailyClick(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketGroupDailyViewCounterConsumer(@Qualifier(value="ticketGroupDailyViewCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketGroupUserDailyView(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketGroupWeekClickCounterConsumer(@Qualifier(value="ticketGroupWeekClickCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketGroupUserWeeklyClick(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer ticketGroupWeekViewCounterConsumer(@Qualifier(value="ticketGroupWeekViewCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketGroupUserWeeklyView(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer getTicketAssetsView(@Qualifier(value="ticketAssetsViewCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketAssetsView(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer getTicketAssetsClick(@Qualifier(value="ticketAssetsClickCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getTicketAssetsClick(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer getPositionTestView(@Qualifier(value="ticketPositionTestViewCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getMediaPositionTestView(), messageListener);
    }

    @Bean(initMethod="init")
    public ShutdownConsumer getPositionTestClick(@Qualifier(value="ticketPositionTestClickCounter") SingleMessageListener messageListener) {
        return this.createConsumer(this.consumer.getMediaPositionTestClick(), messageListener);
    }

    private ShutdownConsumer createConsumer(String consumerId, SingleMessageListener messageListener) {
        Properties properties = this.alionsPropsConfiguration.getConfig();
        if (null == properties) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("properties cannot be null");
            }
            return null;
        }
        if (StringUtils.isBlank((String)consumerId)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("'consumerId' cannot be blank");
            }
            return null;
        }
        Properties newProps = ConsumerAutoConfiguration.copy(properties);
        newProps.putIfAbsent("ConsumerId", consumerId);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Registering consumer: {} of topic: {}", (Object)consumerId, (Object)messageListener.getTopic());
        }
        return new ShutdownConsumer(newProps, (Listener)messageListener);
    }

    private static Properties copy(Properties orig) {
        if (null == orig) {
            return null;
        }
        Properties newProps = new Properties();
        Set<Map.Entry<Object, Object>> entries = orig.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            newProps.put(entry.getKey(), entry.getValue());
        }
        return newProps;
    }
}

