/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.cashier;

import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.message.AbstractMessageListener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.mq.autoconfigure.alions.AlionsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@EnableConfigurationProperties(value={AlionsConfiguration.class, Configuration.class})
public abstract class AdvertiserCashier
extends AbstractMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserCashier.class);
    @Autowired
    @Qualifier(value="jedisCounter")
    private Counter counter;
    @Autowired
    private AlionsConfiguration alionsConfiguration;
    @Autowired
    private Configuration local;
    @Autowired
    private EventPark eventPark;

    protected abstract void afterConsume(ClickRequest var1, Ticket var2, long var3, long var5);

    private long getIncrementValue(ClickRequest request, Ticket ticket) {
        if (request.isValid()) {
            return 0L;
        }
        Integer offerPrice = ticket.getOfferPrice();
        return -(ticket.isCPC() ? (null == offerPrice ? ticket.getPrice() : offerPrice) : 0);
    }

    protected void consume(Message message, Object request, Object returning) {
        this.consume((ClickRequest)request, (Ticket)returning);
    }

    private void consume(ClickRequest request, Ticket ticket) {
        block2: {
            long incrementValue = this.getIncrementValue(request, ticket);
            long remain = this.increment(request.getUid(), ticket, incrementValue);
            try {
                this.afterConsume(request, ticket, incrementValue, remain);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("afterConsume: ", (Throwable)e);
            }
        }
    }

    private long increment(String uid, Ticket ticket, long inc) {
        KeyGenerator keyGenerator = TicketKeyGenerator.Advertiser.getBalance();
        return this.counter.hincrementByAndGet(keyGenerator, String.valueOf(ticket.getAdvertiser()), inc);
    }

    public String getTopic() {
        return this.local.getTopic().getClick();
    }
}

