/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={Configuration.class})
public class TicketDailyClickCounter
extends AbstractClickCounter
implements HashCounter {
    @Autowired
    private Configuration local;

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        return clickRequest.isValid() ? 0L : 1L;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getClickOfDaily();
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest click = this.convertRequest(request);
        return String.valueOf(click.getTicketId());
    }
}

