/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.counter.event.BudgetNotEnoughOfDailyEvent;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.media.PositionGroupService;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.math.BigInteger;
import java.util.EventObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TicketForCpaDailyBudgetCounter
extends AbstractViewCounter
implements HashCounter {
    @Autowired
    private EventPark eventPark;
    @Reference(version="1.0.0")
    private PositionGroupService positionGroupService;

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ViewRequest view = this.convertRequest(request);
        return String.valueOf(view.getTicketId());
    }

    @Override
    protected long getIncrementValue(ViewRequest ticketRequest, Ticket ticket) {
        return ticket.isCPC() ? 0L : 1L;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfDaily();
    }

    @Override
    protected void beforeIncrement(long val, ViewRequest clickRequest, Ticket ticket) {
        String position = clickRequest.getPosition();
        BigInteger ticketId = ticket.getId();
        this.positionGroupService.incrementIfNecessary(ticketId, position, val);
    }

    @Override
    protected void afterIncrement(long val, ViewRequest viewRequest, Ticket ticket) {
        if (val >= (long)ticket.getBudgetDaily().intValue()) {
            this.eventPark.post((EventObject)new BudgetNotEnoughOfDailyEvent(this, ticket));
        }
    }
}

