/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.counter.ticket.counter.utils.CounterUtils;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketForCpaHourlyBudgetCounter
extends AbstractViewCounter
implements HashCounter {
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private EventPark eventPark;
    @Reference(version="1.0.0")
    private TicketStatisticsService ticketStatisticsService;

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ViewRequest view = this.convertRequest(request);
        return String.valueOf(view.getTicketId());
    }

    @Override
    protected long getIncrementValue(ViewRequest ticketRequest, Ticket ticket) {
        return ticket.isCPC() ? 0L : 1L;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfHourly();
    }

    @Override
    protected void afterIncrement(long val, ViewRequest viewRequest, Ticket ticket) {
        CounterUtils.doBudgetOfHourly(this, this.ticketStatisticsService, this.fetcher, this.eventPark, ticket);
    }
}

