/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.counter.event.BudgetNotEnoughOfDailyEvent;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.media.PositionGroupService;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.math.BigInteger;
import java.util.EventObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketForCpcDailyBudgetCounter
extends AbstractClickCounter
implements HashCounter {
    @Autowired
    private EventPark eventPark;
    @Reference(version="1.0.0")
    private PositionGroupService positionGroupService;
    @Autowired(required=false)
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest click = this.convertRequest(request);
        return String.valueOf(click.getTicketId());
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        if (clickRequest.isValid()) {
            return 0L;
        }
        Integer offerPrice = ticket.getOfferPrice();
        return ticket.isCPC() ? (null == offerPrice ? ticket.getPrice() : offerPrice) : 0;
    }

    @Override
    protected void beforeIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        String position = clickRequest.getPosition();
        BigInteger ticketId = ticket.getId();
        this.positionGroupService.incrementIfNecessary(ticketId, position, val);
    }

    @Override
    protected void afterIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        if (val >= (long)ticket.getBudgetDaily().intValue()) {
            this.eventPark.post((EventObject)new BudgetNotEnoughOfDailyEvent(this, ticket));
        }
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfDaily();
    }
}

