/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.OcpcService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Lock;
import com.bxm.warcar.integration.message.AbstractMessageListener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Component;

@Component
public class TicketOcpcClickCounter
extends AbstractMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketOcpcClickCounter.class);
    private static final String COLLECTION_NAME_PREFIX = "ocpc";
    private static final ConcurrentHashMap<String, Object> COLLECTIONNAME_CACHE = new ConcurrentHashMap();
    private final MongoTemplate mongoTemplate;
    private final Configuration configuration;
    @Reference(version="1.0.0", timeout=60000)
    private OcpcService ocpcService;
    @Autowired
    @Qualifier(value="jedisLock")
    private Lock lock;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="mongoTemplate3")
    private MongoTemplate mongoTemplate3;

    public TicketOcpcClickCounter(MongoTemplate mongoTemplate, Configuration configuration) {
        this.mongoTemplate = mongoTemplate;
        this.configuration = configuration;
    }

    protected void consume(Message message, Object request, Object returning) {
        this.consume(message, (ClickRequest)request, (Ticket)returning);
    }

    private boolean isDiscard() {
        String value = (String)this.fetcher.fetch(() -> KeyBuilder.build((Object[])new Object[]{"AD", "TMP", "OCPC_DISCARD"}), String.class);
        return StringUtils.equals((String)"true", (String)value);
    }

    private void consume(Message message, ClickRequest request, Ticket returning) {
        if (!returning.isOcpc()) {
            return;
        }
        if (this.isDiscard()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Discard message: {}", (Object)message.getMsgId());
            }
            return;
        }
        String position = request.getPosition();
        BigInteger ticketId = request.getTicketId();
        boolean valid = request.isValid();
        if (valid) {
            long begin = System.currentTimeMillis();
            String[] array = StringUtils.split((String)position, (char)'-');
            if (ArrayUtils.getLength((Object)array) < 2) {
                return;
            }
            int lastHours = 24;
            Count clickStat = this.aggregateClick(array[0], array[1], ticketId, lastHours);
            Count validStat = this.aggregateVClick(array[0], array[1], ticketId, lastHours);
            long consume = clickStat.getConsume();
            long validClickCount = validStat.getValidClickCount();
            this.ocpcService.doValidClick(returning, position, consume, validClickCount);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Process [{}/{}] click of valid data {}, {} in {} ms", new Object[]{position, ticketId, validClickCount, consume, System.currentTimeMillis() - begin});
            }
        }
    }

    private Count aggregateClick(String appkey, String business, BigInteger ticketId, int lastHours) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - lastHours);
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"clicktime").gte((Object)calendar.getTime()).and("appkey").is((Object)appkey).and("business").is((Object)business).and("preid").is((Object)TypeHelper.castToInt((Object)ticketId)).and("modeltype").is((Object)7));
        GroupOperation group = Aggregation.group((String[])new String[0]).sum("valid").as("validClickCount").count().as("clickCount").sum("offerprice").as("consume");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group});
        String collectionName = "countAwradmsgDetail2";
        AggregationResults output = this.mongoTemplate3.aggregate(aggregation, collectionName, Count.class);
        List results = output.getMappedResults();
        if (null == results) {
            return Count.empty();
        }
        Iterator iterator = results.iterator();
        return iterator.hasNext() ? (Count)iterator.next() : Count.empty();
    }

    private Count aggregateVClick(String appkey, String business, BigInteger ticketId, int lastHours) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, calendar.get(11) - lastHours);
        MatchOperation match = Aggregation.match((Criteria)Criteria.where((String)"created").gte((Object)calendar.getTime()).and("shotAppkey").is((Object)appkey).and("shotBusiness").is((Object)business).and("shotCertificateid").is((Object)TypeHelper.castToInt((Object)ticketId)));
        GroupOperation group = Aggregation.group((String[])new String[0]).count().as("validClickCount");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{match, group});
        String collectionName = "countTicketAdvertiser2";
        AggregationResults output = this.mongoTemplate3.aggregate(aggregation, collectionName, Count.class);
        List results = output.getMappedResults();
        if (null == results) {
            return Count.empty();
        }
        Iterator iterator = results.iterator();
        return iterator.hasNext() ? (Count)iterator.next() : Count.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCollectionIfNecess(String collectionName) {
        String keyName = KeyBuilder.build((Object[])new Object[]{"AD", "LOCK", collectionName});
        if (!this.lock.tryAcquire(keyName)) {
            return;
        }
        try {
            DB db = this.mongoTemplate.getDb();
            if (!db.collectionExists(collectionName)) {
                BasicDBObject options = new BasicDBObject();
                options.put("capped", (Object)true);
                options.put("size", (Object)this.configuration.getOcpc().getMaxSize());
                options.put("max", (Object)this.configuration.getOcpc().getDocumentsMax());
                DBCollection collection = db.createCollection(collectionName, (DBObject)options);
                BasicDBObject idxTime = new BasicDBObject();
                idxTime.put("time", (Object)-1);
                collection.createIndex((DBObject)idxTime);
                BasicDBObject idxBillid = new BasicDBObject();
                idxBillid.put("billid", (Object)-1);
                collection.createIndex((DBObject)idxBillid);
            }
            COLLECTIONNAME_CACHE.put(collectionName, new Object());
        }
        finally {
            this.lock.release(keyName);
        }
    }

    private String createCollectionName(String position, BigInteger ticketId) {
        return StringUtils.join((Object[])new Object[]{COLLECTION_NAME_PREFIX, ticketId, position}, (char)'_');
    }

    public String getTopic() {
        return this.configuration.getTopic().getClick();
    }

    static class Count
    implements Serializable {
        private static final long serialVersionUID = -3784449261767131582L;
        private long consume;
        private long clickCount;
        private long validClickCount;

        Count() {
        }

        static Count empty() {
            return new Count();
        }

        public long getConsume() {
            return this.consume;
        }

        public void setConsume(long consume) {
            this.consume = consume;
        }

        public long getClickCount() {
            return this.clickCount;
        }

        public void setClickCount(long clickCount) {
            this.clickCount = clickCount;
        }

        public long getValidClickCount() {
            return this.validClickCount;
        }

        public void setValidClickCount(long validClickCount) {
            this.validClickCount = validClickCount;
        }

        public String toString() {
            return "Count{consume=" + this.consume + ", clickCount=" + this.clickCount + ", validClickCount=" + this.validClickCount + '}';
        }
    }
}

