/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.counter.ticket.counter.ocpc.OcpcWindowedBeans;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.OcpcService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.cache.Windowed;
import com.bxm.warcar.integration.message.AbstractMessageListener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.utils.KeyBuilder;
import java.math.BigInteger;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class TicketOcpcClickWindowedCounter
extends AbstractMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketOcpcClickWindowedCounter.class);
    private static final String PREFIX = KeyBuilder.build((Object[])new Object[]{"AD", "WINDOWED"});
    private static final String PREFIX_CONSUME = KeyBuilder.build((Object[])new Object[]{PREFIX, "CONSUME"});
    private static final String PREFIX_VCLICK = KeyBuilder.build((Object[])new Object[]{PREFIX, "VCLICK"});
    private final Configuration configuration;
    private final OcpcWindowedBeans ocpcWindowedBeans;
    @Reference(version="1.0.0", timeout=60000)
    private OcpcService ocpcService;

    public TicketOcpcClickWindowedCounter(Configuration configuration, OcpcWindowedBeans ocpcWindowedBeans) {
        this.configuration = configuration;
        this.ocpcWindowedBeans = ocpcWindowedBeans;
    }

    protected void consume(Message message, Object request, Object returning) {
        this.consume(message, (ClickRequest)request, (Ticket)returning);
    }

    private void consume(Message message, ClickRequest request, Ticket returning) {
        if (!returning.isOcpc()) {
            return;
        }
        String position = request.getPosition();
        BigInteger ticketId = request.getTicketId();
        boolean valid = request.isValid();
        int offerPrice = NumberUtils.toInt((String)String.valueOf(returning.getOfferPrice()));
        String pConsume = KeyBuilder.build((Object[])new Object[]{PREFIX_CONSUME, position, ticketId});
        String pVclick = KeyBuilder.build((Object[])new Object[]{PREFIX_VCLICK, position, ticketId});
        Windowed pConsumeWindowed = this.ocpcWindowedBeans.getWindowed(pConsume);
        Windowed pVclickWindowed = this.ocpcWindowedBeans.getWindowed(pVclick);
        if (valid) {
            long start = System.currentTimeMillis();
            pVclickWindowed.execute(1.0);
            double vclick = pVclickWindowed.get();
            double consume = pConsumeWindowed.get();
            this.ocpcService.doValidClick(returning, position, (long)consume, (long)vclick);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Process click of valid data {}, {} in {} ms", new Object[]{vclick, consume, System.currentTimeMillis() - start});
            }
        } else {
            pConsumeWindowed.execute((double)offerPrice);
        }
    }

    public String getTopic() {
        return this.configuration.getTopic().getClick();
    }
}

