/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.dal.media.PositionTestMapper;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.adsprod.facade.ticket.media.PositionTest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TicketPositionTestViewCounter
extends AbstractViewCounter
implements HashCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketPositionTestViewCounter.class);
    private static final Short STATUS = 2;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private PositionTestMapper positionTestMapper;

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ViewRequest view = this.convertRequest(request);
        return String.valueOf(view.getTicketId());
    }

    @Override
    protected KeyGenerator getKeyGenerator(ViewRequest viewRequest, Ticket ticket) {
        return TicketKeyGenerator.Statistics.getPositionIdTestViews((String)viewRequest.getPosition());
    }

    @Override
    protected boolean isIncrementIfNeeded(ViewRequest request, Ticket ticket) {
        return false;
    }

    @Override
    protected void afterIncrement(long val, ViewRequest viewRequest, Ticket ticket) {
        super.afterIncrement(val, viewRequest, ticket);
    }

    public Boolean isUpdate(Long count, Map<String, Long> map) {
        for (Long viewCount : map.values()) {
            if (viewCount >= count) continue;
            return false;
        }
        return true;
    }

    public Boolean isNeed(String ticketId, String positionId, PositionTest positionTest) {
        Map map = this.fetcher.hfetchall(TicketKeyGenerator.Statistics.getPositionIdTestViews((String)positionId), Long.class);
        if (map == null || map.get(ticketId) == null || map.get(ticketId) != null && (Long)map.get(ticketId) < positionTest.getCount()) {
            return true;
        }
        if (this.isUpdate(positionTest.getCount(), map).booleanValue() && map.size() == positionTest.getTicketId().split(",").length) {
            this.positionTestMapper.updatePositionTest(new Date(), positionId);
        }
        return false;
    }

    public static boolean after(Date date1, Date date2) {
        long date1Long = date1.getTime();
        long date2Long = date2.getTime();
        return TicketPositionTestViewCounter.after(date1Long, date2Long);
    }

    public static boolean after(long data1, long data2) {
        return data1 - data2 > 0L;
    }
}

