/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.counter.ticket.counter.entity.TicketWeightBaseData;
import com.bxm.adsprod.counter.ticket.counter.utils.CounterUtils;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.integration.message.AbstractMessageListener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.mongodb.core.MongoTemplate;

@Deprecated
@EnableConfigurationProperties(value={Configuration.class})
public class TicketViewCounter
extends AbstractMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketViewCounter.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Configuration configuration;
    private static final int SHUTDOWN_WAIT_TIME_OUT_SECOND = 10;
    private volatile int copyTimes = 0;
    private List<TicketWeightBaseData> bucket1 = Collections.synchronizedList(Lists.newArrayList());
    private List<TicketWeightBaseData> bucket2 = Collections.synchronizedList(Lists.newArrayList());
    private ScheduledExecutorService scheduled = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("scheduled"));

    protected void consume(Message message, Object request, Object returning) {
        this.consume(message, (ViewRequest)request, (Ticket)returning);
    }

    @PostConstruct
    public void init() {
        CounterUtils.createCollectionIfNecess(this.mongoTemplate, this.configuration, TicketWeightBaseData.getCollectionName());
        this.scheduled.scheduleWithFixedDelay(new Runnable(){

            @Override
            public synchronized void run() {
                List tmp;
                TicketViewCounter.this.copyTimes++;
                long start = System.currentTimeMillis();
                List list = tmp = TicketViewCounter.this.isEvenTimes() ? TicketViewCounter.this.bucket1 : TicketViewCounter.this.bucket2;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("copy times: {}, Bucket data size: {}", (Object)TicketViewCounter.this.copyTimes, (Object)tmp.size());
                }
                if (CollectionUtils.isNotEmpty((Collection)tmp)) {
                    TicketViewCounter.this.mongoTemplate.insert((Collection)tmp, TicketWeightBaseData.getCollectionName());
                }
                tmp.clear();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Process finished in {} ms", (Object)(System.currentTimeMillis() - start));
                }
            }
        }, 1000L, 5000L, TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void destroy() {
        this.scheduled.shutdown();
        try {
            if (!this.scheduled.awaitTermination(10L, TimeUnit.SECONDS) && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Wait for the thread pool execution finish has been time out!");
            }
        }
        catch (InterruptedException e) {
            this.scheduled.shutdownNow();
        }
    }

    private void consume(Message message, ViewRequest request, Ticket ticket) {
        BigInteger ticketId = ticket.getId();
        TicketWeightBaseData o = new TicketWeightBaseData();
        o.setPosition(request.getPosition());
        o.setSettleType(ticket.getSettleType());
        o.setModeltype(6);
        o.setModelvalue(1);
        o.setTicketid(ticketId);
        o.setTime(ticket.getTime());
        if (null != request.getAssetsId()) {
            o.setAssetsId(request.getAssetsId());
        }
        if (this.isEvenTimes()) {
            this.bucket2.add(o);
        } else {
            this.bucket1.add(o);
        }
    }

    private boolean isEvenTimes() {
        return this.copyTimes % 2 == 0;
    }

    public String getTopic() {
        return this.configuration.getTopic().getView();
    }
}

