/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.counter.utils;

import com.bxm.adsprod.counter.event.BudgetNotEnoughOfHourlyEvent;
import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.model.so.rules.TicketTimelineRuleSo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.EventObject;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;

public final class CounterUtils {
    private CounterUtils() {
    }

    public static void createCollectionIfNecess(MongoTemplate mongoTemplate, Configuration configuration, String collectionName) {
        DB db = mongoTemplate.getDb();
        if (!db.collectionExists(collectionName)) {
            BasicDBObject options = new BasicDBObject();
            options.put("capped", (Object)true);
            options.put("size", (Object)configuration.getMongo().getBaseMaxSize());
            options.put("max", (Object)configuration.getMongo().getBaseDocumentsMax());
            DBCollection collection = db.createCollection(collectionName, (DBObject)options);
            BasicDBObject index = new BasicDBObject();
            index.put("time", (Object)-1);
            collection.createIndex((DBObject)index);
        }
    }

    public static void doBudgetOfHourly(Object source, TicketStatisticsService ticketStatisticsService, Fetcher fetcher, EventPark eventPark, Ticket ticket) {
        if (null == source) {
            return;
        }
        if (null == fetcher) {
            return;
        }
        if (null == eventPark) {
            return;
        }
        if (null == ticket) {
            return;
        }
        TicketTimelineRuleSo config = (TicketTimelineRuleSo)fetcher.fetch(TicketKeyGenerator.Filter.getTimeline((BigInteger)ticket.getId()), null, TicketTimelineRuleSo.class);
        if (null == config) {
            return;
        }
        int currentHour = Calendar.getInstance().get(11);
        List rules = config.getEntries();
        for (TicketTimelineRuleSo.Entry rule : rules) {
            int startHour = rule.getStartHour();
            int endHour = rule.getEndHour();
            long max = rule.getLimit();
            boolean isTimeNow = currentHour >= startHour && currentHour < endHour;
            if (!isTimeNow) continue;
            long budgetOfTimeline = ticketStatisticsService.getBudgetOfTimeline(ticket.getId(), startHour, endHour);
            if (budgetOfTimeline >= max) {
                eventPark.post((EventObject)new BudgetNotEnoughOfHourlyEvent(source, ticket, currentHour, startHour, endHour));
            }
            return;
        }
        eventPark.post((EventObject)new BudgetNotEnoughOfHourlyEvent(source, ticket));
    }
}

