/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.counter.ticket.recorder;

import com.bxm.adsprod.counter.properties.Configuration;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.message.AbstractMessageListener;
import com.bxm.warcar.mq.Message;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={Configuration.class})
public class UserLastTicketRecorder
extends AbstractMessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserLastTicketRecorder.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private Configuration local;

    protected void consume(Message message, ViewRequest request, Ticket ticket) {
        this.setLastAcquireTicket(ticket, request.getUid());
    }

    protected void consume(Message message, Object request, Object returning) {
        this.consume(message, (ViewRequest)request, (Ticket)returning);
    }

    public String getTopic() {
        return this.local.getTopic().getView();
    }

    private void setLastAcquireTicket(Ticket ticket, String uid) {
        if (null == ticket) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("ticket is null.");
            }
            return;
        }
        if (StringUtils.isBlank((String)uid)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("uid is null.");
            }
            return;
        }
        Integer expire = TypeHelper.castToInt((Object)DateHelper.getRemainSecondsOfToday());
        this.updater.update(TicketKeyGenerator.User.getUser((String)uid), (Object)ticket, expire.intValue());
        HashSet<String> alreadys = (HashSet<String>)this.fetcher.fetch(TicketKeyGenerator.Scene.getSceneViews((int)1, (String)uid), null, Set.class);
        if (null == alreadys) {
            alreadys = new HashSet<String>();
        }
        alreadys.add(String.valueOf(ticket.getId()));
        this.updater.update(TicketKeyGenerator.Scene.getSceneViews((int)1, (String)uid), alreadys, expire.intValue());
    }
}

