package com.bxm.adsprod.dal.ticket;

import com.bxm.adsprod.model.dao.ticket.TicketProfitDao;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigInteger;
import java.util.List;

/**
 *
 * @author allen
 * @since V1.0.0 2018/01/04
 */
@Mapper
public interface TicketProfitMapper {

    /**
     * 返回CPA广告券的收益
     * @param datetime 日期
     * @return CPA 广告券的收益
     */
    @Deprecated
    List<TicketProfitDao> selectProfitForCpa(@Param("datetime") String datetime);

    /**
     * 返回这个广告券最近<code>days</code>天内有收益的最后一天的数据
     * @param position
     * @param ticketId
     * @return
     */
    TicketProfitDao selectByLast(@Param("position") String position, @Param("ticketId") BigInteger ticketId, @Param("days") int days);

    List<TicketProfitDao> selectAllByLast(@Param("appkey") String appkey, @Param("business") String business, @Param("days") int days);

    /**
     * 返回这个广告券指定那天的收益数据
     * @param ticketId
     * @param datetime
     * @return
     */
    TicketProfitDao selectByDatetime(@Param("ticketId") BigInteger ticketId, @Param("datetime") String datetime);

    List<TicketProfitDao> selectAllByDatetime(@Param("datetime") String datetime);
}
