package com.bxm.adsprod.facade.ticket;

import java.math.BigInteger;

/**
 * @author allen
 * @since 1.0.0
 */
public interface OcpcService {

    /**
     * 出价
     * @param ticket
     * @param position
     * @return
     */
    int offer(Ticket ticket, String position) throws OcpcOfferException;

    /**
     * 当前广告券的出价是否低于底价
     * @param ticket
     * @param position
     * @return
     */
    boolean isUnderFloorPrice(Ticket ticket, String position) throws OcpcOfferException;

    /**
     * 处理有效点击逻辑
     *
     * @param ticket
     * @param position
     */
    void doValidClick(Ticket ticket, String position);

    /**
     * @param ticketId
     * @param position
     * @param newValue
     */
    void resetConsume(BigInteger ticketId, String position, long newValue);

    /**
     * @param ticketId
     * @param position
     * @param newValue
     */
    void resetValidClickCount(BigInteger ticketId, String position, long newValue);

    /**
     * 是否达到了关闭的条件
     *
     * 关闭条件有两个因素：点击次数+有效点击次数
     * @param ticket
     * @param position
     * @return
     */
    void doClick(Ticket ticket, String position);

    /**
     * 返回底价
     * @return
     */
    int getFloorPrice(int defaultValue);
}
