/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.facade.ticket;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;

public final class TicketKeyGenerator {
    public static KeyGenerator getUser(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "USER", parameters.get("imei")});
    }

    public static KeyGenerator getTimes(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TIMES", parameters.get("ticketid")});
    }

    public static KeyGenerator getTicketAssets() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ASSETS"});
    }

    public static KeyGenerator getAvailableTickets() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "AVAILABLE"});
    }

    public static KeyGenerator getAllTickets() {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "ALL"});
    }

    public static KeyGenerator getTicketPrice(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE", parameters.get("ticketid"), parameters.get("positionid")});
    }

    public static KeyGenerator getTicketPriceOfTodayFirst(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE_TF", parameters.get("ticketid"), parameters.get("positionid")});
    }

    public static KeyGenerator getTicketPriceFloatPercent(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PRICE_FP", parameters.get("ticketid"), parameters.get("positionid")});
    }

    public static KeyGenerator getTicketMif(Map<String, Object> parameters) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_MIF", parameters.get("ticketid"), parameters.get("positionid")});
    }

    public static KeyGenerator getTicketProfitForCpa(LocalDate date) {
        return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET_PROFIT_FOR_CPA", date.format(DateTimeFormatter.ofPattern("yyyyMMdd"))});
    }

    public static class Temp {
        private Temp() {
        }

        public static KeyGenerator getTimelineOutOfBudget(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TEMP", "TIMELINE", "OUT_OF_BUDGET", ticketId});
        }

        public static KeyGenerator getTickets(int os, int app, String regionCode, String position) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TEMP", "TICKET", os, app, regionCode, position});
        }
    }

    public static class Ocpc {
        public static KeyGenerator getConsume(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "CONSUME", ticketId});
        }

        public static KeyGenerator getClick(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "CLICK", ticketId});
        }

        public static KeyGenerator getValidClick(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "VALIDCLICK", ticketId});
        }

        public static KeyGenerator getClosed(String position) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "CLOSED", position});
        }

        public static KeyGenerator getFloor() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "FLOOR"});
        }

        public static KeyGenerator getOfferSheetLock(String position, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "OFFER_SHEET_LOCK", position, ticketId});
        }

        public static KeyGenerator getOfferSheet(String position, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "OFFER_SHEET", position, ticketId});
        }
    }

    public static class Scene {
        private Scene() {
        }

        public static KeyGenerator getScene(int scene) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "TICKET", "SCENE", scene});
        }

        public static KeyGenerator getSceneViews(int scene, String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "SCENE", scene, uid});
        }
    }

    public static class Weight {
        @Deprecated
        public static KeyGenerator getWeight(BigInteger ticketId, String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET", ticketId});
        }

        public static KeyGenerator getWeight(String positionId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "WEIGHT", "TICKET", positionId});
        }
    }

    public static class Statistics {
        private Statistics() {
        }

        public static KeyGenerator getBudgetOfDaily() {
            return Statistics.getBudgetOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getBudgetOfDaily(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "DAILY_BUDGET", date});
        }

        public static KeyGenerator getClickOfDaily() {
            return Statistics.getClickOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getClickOfDaily(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "CLICK", date});
        }

        public static KeyGenerator getViewOfDaily() {
            return Statistics.getViewOfDaily(DateHelper.format((String)"yyyyMMdd"));
        }

        public static KeyGenerator getViewOfDaily(String date) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "VIEW", date});
        }

        public static KeyGenerator getPositionViewOfDaily(String position) {
            return Statistics.getPositionViewOfDaily(DateHelper.format((String)"yyyyMMdd"), position);
        }

        public static KeyGenerator getPositionViewOfDaily(String date, String position) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "VIEW", date, position});
        }

        public static KeyGenerator getBudgetOfHourly() {
            return Statistics.getBudgetOfHourly(NumberUtils.toInt((String)DateHelper.format((String)"H"), (int)-1));
        }

        public static KeyGenerator getBudgetOfHourly(int hour) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "HOURLY_BUDGET", DateHelper.format((String)"yyyyMMdd"), hour});
        }

        public static KeyGenerator getViewOfHourly() {
            return Statistics.getViewOfHourly(NumberUtils.toInt((String)DateHelper.format((String)"H"), (int)-1));
        }

        public static KeyGenerator getViewOfHourly(int hour) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "HOURLY_VIEW", DateHelper.format((String)"yyyyMMdd"), hour});
        }

        public static KeyGenerator getClickOfDaily(BigInteger ticketId) {
            return Statistics.getClickOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getClickOfDaily(String date, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_CLICK", date, ticketId});
        }

        public static KeyGenerator getViewOfDaily(BigInteger ticketId) {
            return Statistics.getViewOfDaily(DateHelper.getDate(), ticketId);
        }

        public static KeyGenerator getViewOfDaily(String date, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UDAILY_VIEW", date, ticketId});
        }

        public static KeyGenerator getClickOfWeekly(BigInteger ticketId) {
            return Statistics.getClickOfWeekly(DateHelper.format((String)"yyyyw"), ticketId);
        }

        public static KeyGenerator getClickOfWeekly(String dateweek, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_CLICK", dateweek, ticketId});
        }

        public static KeyGenerator getViewOfWeekly(BigInteger ticketId) {
            return Statistics.getViewOfWeekly(DateHelper.format((String)"yyyyw"), ticketId);
        }

        public static KeyGenerator getViewOfWeekly(String dateweek, BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "COUNTER", "UWEEKLY_VIEW", dateweek, ticketId});
        }
    }

    public static class User {
        private User() {
        }

        public static KeyGenerator getUser(String uid) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "RECORD", "LAST", uid});
        }
    }

    public static class Media {
        private Media() {
        }

        public static KeyGenerator getPositions() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "POSITION", "ALL"});
        }

        public static KeyGenerator getPositionDomain(Map<String, Object> parameters) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_DOMAIN", parameters.get("positionid"), parameters.get("domaincode")});
        }

        public static KeyGenerator getPositionTag(Map<String, Object> parameters) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION_TAG", parameters.get("positionid"), parameters.get("tagcode")});
        }
    }

    public static class Advertiser {
        private Advertiser() {
        }

        public static KeyGenerator getBalance() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "ADVERTISER", "BALANCE"});
        }
    }

    public static class Filter {
        private Filter() {
        }

        public static KeyGenerator getRegionDefined() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "REGION", "DEFINED"});
        }

        public static KeyGenerator getRegionUndefined() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "REGION", "UNDEFINED"});
        }

        public static KeyGenerator getPositionDefinedBlackList() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "DEFINED", "BLACKLIST"});
        }

        public static KeyGenerator getPositionDefinedWhiteList() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "DEFINED", "WHITELIST"});
        }

        public static KeyGenerator getPositionUndefined() {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "POSITION", "UNDEFINED"});
        }

        public static KeyGenerator getTimeline(BigInteger ticketId) {
            return () -> KeyBuilder.build((Object[])new Object[]{"AD", "FILTER", "TIMELINE", ticketId});
        }
    }
}

