package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.rules.Rule;

import java.util.List;

/**
 * <h3>包含规则的广告券信息</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/28
 */
public class TicketOfRules extends Ticket {

    private static final long serialVersionUID = -5375015030248563075L;

    /**
     * 该广告券配置的素材列表
     */
    private List<TicketAssets> assets;
    /**
     * 广告券地域规则
     */
    private Rule region;
    /**
     * 广告券广告位规则
     */
    private Rule position;
    /**
     * 广告券时间段规则
     */
    private Rule timeline;
    /**
     * 广告券频次规则
     */
    private Rule times;
    /**
     * 广告位组频次规则（流量包）
     */
    private Rule positionGroup;

    public List<TicketAssets> getAssets() {
        return assets;
    }

    public void setAssets(List<TicketAssets> assets) {
        this.assets = assets;
    }

    public Rule getRegion() {
        return region;
    }

    public void setRegion(Rule region) {
        this.region = region;
    }

    public Rule getPosition() {
        return position;
    }

    public void setPosition(Rule position) {
        this.position = position;
    }

    public Rule getTimeline() {
        return timeline;
    }

    public void setTimeline(Rule timeline) {
        this.timeline = timeline;
    }

    public Rule getTimes() {
        return times;
    }

    public void setTimes(Rule times) {
        this.times = times;
    }

    public Rule getPositionGroup() {
        return positionGroup;
    }

    public void setPositionGroup(Rule positionGroup) {
        this.positionGroup = positionGroup;
    }
}
