package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * <h3>有权重的广告券</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
public class TicketWithWeight implements Serializable, Comparable<TicketWithWeight> {

    private static final long serialVersionUID = -3263156074698223503L;

    private String domainCode;
    private BigDecimal weight;
    /**
     * 广告券获取次数（指单个用户）
     * TODO 可以优化，单独抽离出来
     */
    private long count;
    private BigInteger ticketId;

    public TicketWithWeight() {
    }

    public TicketWithWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public TicketWithWeight(BigDecimal weight, long count, String domainCode, BigInteger ticketId) {
        this.weight = weight;
        this.count = count;
        this.domainCode = domainCode;
        this.ticketId = ticketId;
    }

    @Override
    public int compareTo(TicketWithWeight o) {
        // jdk 1.7+ 可能会引发 Comparison method violates its general contract! 异常
//        return o.count == count ?
//                (o.weight.doubleValue() > weight.doubleValue() ? 1 : -1) :
//                o.count < count ? 1 : -1;

        return o.count == count ?
                (Double.compare(o.weight.doubleValue(), weight.doubleValue())) :
                (Long.compare(count, o.count));
    }

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }

    public long getCount() {
        return count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public BigInteger getTicketId() {
        return ticketId;
    }

    public void setTicketId(BigInteger ticketId) {
        this.ticketId = ticketId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
