package com.bxm.adsprod.facade.activity;

import java.util.Map;

/**
 * <h3>Activity Service</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/20
 */
public interface ActivityService {

    
    /**  
	 * @Title: getActMsg  
	 * @Description:  获取活动信息
	 * @author xavier  
	 * @throws Exception 
	 * @date 2018年5月9日
	 */  
	public InfoActivity getActMsg(String actId);
	
	/**  
	 * @Title: getActMsg  
	 * @Description:  获取活动信息MAP
	 * @author xavier  
	 * @date 2018年5月9日
	 */  
	public Map<Integer, Integer> getBizActMsg(String positionId);
	
	/**  
	 * @Title: getDefaultActMsg  
	 * @Description: 获取默认配置的活动信息 
	 * @author xavier  
	 * @throws Exception 
	 * @date 2018年5月9日
	 */  
	public Map<Integer, Integer> getDefaultActConf();
	
	/**  
	 * @Title: getDefaultActMsg  
	 * @Description:  获取默认活动信息
	 * @author xavier  
	 * @date 2018年5月9日
	 */  
	public InfoActivity getDefaultActMsg();

	/**  
	 * @Title: getBakActMsg  
	 * @Description:  获取备用活动信息
	 * @author xavier  
	 * @date 2018年5月9日
	 */  
	public Map<Integer, Integer> getBakActMsg();
	
	/**  
	 * @Title: getActivity  
	 * @Description:  根据用户和positionId 获取活动信息
	 * @author xavier  
	 * @date 2018年5月15日
	 */  
	public InfoActivity getActivity(String uid,String positionId);

}
