package com.bxm.adsprod.facade.media;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

/**
 * DSP信息<br/>
 *
 * @author kerry.jiang
 * @date 2019/11/5 13:37
 */
public class OuterDsp implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * DSP代码
     * 我司自定义
     * @see com.bxm.adsprod.service.commons.adapi.adapter.EAdAdapter
     */
    private String dsp_code;
    /**
     * 对应我司的广告券ID
     */
    private BigInteger ticket_id;
    /**
     * 广告平台的广告位信息
     */
    private List<OuterDspPosition> positions;

    public String getDsp_code() {
        return dsp_code;
    }

    public void setDsp_code(String dsp_code) {
        this.dsp_code = dsp_code;
    }

    public BigInteger getTicket_id() {
        return ticket_id;
    }

    public void setTicket_id(BigInteger ticket_id) {
        this.ticket_id = ticket_id;
    }

    public List<OuterDspPosition> getPositions() {
        return positions;
    }

    public void setPositions(List<OuterDspPosition> positions) {
        this.positions = positions;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}