package com.bxm.adsprod.facade.media.sdk;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * SDK初始化信息<br/>
 *
 * @author kerry.jiang
 * @date 2019/11/5 13:37
 */
public class SdkInitCache implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 设备id
     */
    private String deviceId;
    /**
     * IMEI（安卓）
     */
    private String imei;
    /**
     * IDFA（IOS）
     */
    private String idfa;
    /**
     * mac地址
     */
    private String mac;
    /**
     * IP地址
     */
    private String ip;
    /**
     * 经度
     */
    private String longitude;
    /**
     * 纬度
     */
    private String latitude;
    /**
     * 设备型号(机型)
     */
    private String deviceModel;
    /**
     * 设备品牌
     */
    private String deviceBrand;
    /**
     * 设备类型（手机、平板）
     * 1：手机
     * 2：平板
     */
    private String deviceType;
    /**
     * 内存(单位G)
     */
    private Double memory;
    /**
     * 存储空间
     */
    private Double storageSpace;
    /**
     * cpu型号
     */
    private String cpuModel;
    /**
     * 安卓或者ios系统版本号
     */
    private String osVersion;
    /**
     * 安装应用的包名
     */
    private String packageName;
    /**
     * 手机网络运行商
     * 0：未知
     * 1：移动
     * 2：联通
     * 3：电信
     */
    private String ispDomain;
    /**
     * sdk版本
     */
    private String sdkVersion;
    /**
     * appKey
     */
    private String appKey;
    /**
     * 联网方式
     * 0: 未知
     * 1: 以太网
     * 2: WIFI
     * 3: 2G
     * 4: 3G
     * 5: 4G
     * 6: 5G
     */
    private String netType;
    /**
     * SDK类型
     * 1：初始版本
     * 2：流量分配版本
     */
    private Integer sdkType;
    /**
     * 系统
     * 1：安卓
     * 2：IOS
     */
    private Byte os;
    /**
     * android id（安卓）
     * SDK1.3.1
     */
    private String androidId;
    /**
     * open device id（安卓10.0以上）
     * SDK1.3.1
     */
    private String odid;
    /**
     * 设备屏幕高度
     * SDK1.3.1
     */
    private Integer screenHeight;
    /**
     * 设备屏幕宽度
     * SDK1.3.1
     */
    private Integer screenWidth;

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getDeviceModel() {
        return deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getDeviceBrand() {
        return deviceBrand;
    }

    public void setDeviceBrand(String deviceBrand) {
        this.deviceBrand = deviceBrand;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public Double getMemory() {
        return memory;
    }

    public void setMemory(Double memory) {
        this.memory = memory;
    }

    public Double getStorageSpace() {
        return storageSpace;
    }

    public void setStorageSpace(Double storageSpace) {
        this.storageSpace = storageSpace;
    }

    public String getCpuModel() {
        return cpuModel;
    }

    public void setCpuModel(String cpuModel) {
        this.cpuModel = cpuModel;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getIspDomain() {
        return ispDomain;
    }

    public void setIspDomain(String ispDomain) {
        this.ispDomain = ispDomain;
    }

    public String getSdkVersion() {
        return sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getNetType() {
        return netType;
    }

    public void setNetType(String netType) {
        this.netType = netType;
    }

    public Integer getSdkType() {
        return sdkType;
    }

    public void setSdkType(Integer sdkType) {
        this.sdkType = sdkType;
    }

    public Byte getOs() {
        return os;
    }

    public void setOs(Byte os) {
        this.os = os;
    }

    public String getAndroidId() {
        return androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    public String getOdid() {
        return odid;
    }

    public void setOdid(String odid) {
        this.odid = odid;
    }

    public Integer getScreenHeight() {
        return screenHeight;
    }

    public void setScreenHeight(Integer screenHeight) {
        this.screenHeight = screenHeight;
    }

    public Integer getScreenWidth() {
        return screenWidth;
    }

    public void setScreenWidth(Integer screenWidth) {
        this.screenWidth = screenWidth;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}