package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;

/**
 * 统计抽象请求类
 * @author zhiwen.li
 *
 */
public class CounterRequest implements Serializable {

    private static final long serialVersionUID = -2274554208610900757L;

    /**
     * 本次请求的票据号，来源于{@link TicketService#get(TicketRequest) 获取广告券接口}。
     */
    private String ticket;

    public boolean isEmptyTicket() {
        return StringUtils.isBlank(ticket);
    }

    public String getTicket() {
        return ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }
}
