package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <h3>激励视频第三方信息</h3>
 *
 * @author kerry.jiang
 * @date 2019/8/5 17:55
 */
public class TicketInspireOuter implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    /**
     * 服务器激励回调上报URL
     */
    private List<String> callbackTrackers;
    /**
     * 加载成功监测
     */
    private List<String> loadedTrackers;
    /**
     * 播放错误监测
     */
    private List<String> playErrorTrackers;
    /**
     * 播放错误代码
     * 1：视频地址为空
     * 2：视频缓存失败
     * 3：视频播放失败
     * 4：结束页内容为空
     */
    private Map<String, String> playErrorCodeMap;
    /**
     * 曝光监测
     */
    private List<String> viewTrackers;
    /**
     * 点击监测
     */
    private List<String> clickTrackers;
    /**
     * 暂停播放
     */
    private List<String> pauseTrackers;
    /**
     * 继续播放
     */
    private List<String> resumeTrackers;
    /**
     * 关闭视频
     */
    private List<String> closeTrackers;
    /**
     * 静音播放
     */
    private List<String> muteTrackers;
    /**
     * 关闭静音播放
     */
    private List<String> unmuteTrackers;
    /**
     * 播放进度监测
     */
    private List<TicketInspirePlayProgress> playProgress;

    public List<String> getCallbackTrackers() {
        return callbackTrackers;
    }

    public void setCallbackTrackers(List<String> callbackTrackers) {
        this.callbackTrackers = callbackTrackers;
    }

    public List<String> getLoadedTrackers() {
        return loadedTrackers;
    }

    public void setLoadedTrackers(List<String> loadedTrackers) {
        this.loadedTrackers = loadedTrackers;
    }

    public List<String> getPlayErrorTrackers() {
        return playErrorTrackers;
    }

    public void setPlayErrorTrackers(List<String> playErrorTrackers) {
        this.playErrorTrackers = playErrorTrackers;
    }

    public Map<String, String> getPlayErrorCodeMap() {
        return playErrorCodeMap;
    }

    public void setPlayErrorCodeMap(Map<String, String> playErrorCodeMap) {
        this.playErrorCodeMap = playErrorCodeMap;
    }

    public List<String> getViewTrackers() {
        return viewTrackers;
    }

    public void setViewTrackers(List<String> viewTrackers) {
        this.viewTrackers = viewTrackers;
    }

    public List<String> getClickTrackers() {
        return clickTrackers;
    }

    public void setClickTrackers(List<String> clickTrackers) {
        this.clickTrackers = clickTrackers;
    }

    public List<String> getPauseTrackers() {
        return pauseTrackers;
    }

    public void setPauseTrackers(List<String> pauseTrackers) {
        this.pauseTrackers = pauseTrackers;
    }

    public List<String> getResumeTrackers() {
        return resumeTrackers;
    }

    public void setResumeTrackers(List<String> resumeTrackers) {
        this.resumeTrackers = resumeTrackers;
    }

    public List<String> getCloseTrackers() {
        return closeTrackers;
    }

    public void setCloseTrackers(List<String> closeTrackers) {
        this.closeTrackers = closeTrackers;
    }

    public List<String> getMuteTrackers() {
        return muteTrackers;
    }

    public void setMuteTrackers(List<String> muteTrackers) {
        this.muteTrackers = muteTrackers;
    }

    public List<String> getUnmuteTrackers() {
        return unmuteTrackers;
    }

    public void setUnmuteTrackers(List<String> unmuteTrackers) {
        this.unmuteTrackers = unmuteTrackers;
    }

    public List<TicketInspirePlayProgress> getPlayProgress() {
        return playProgress;
    }

    public void setPlayProgress(List<TicketInspirePlayProgress> playProgress) {
        this.playProgress = playProgress;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
