package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigInteger;

/**
 * <h3>激励视频信息</h3>
 *
 * @author kerry.jiang
 * @date 2019/8/5 17:55
 */
public class TicketInspire implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    /**
     * 广告券ID
     */
    private BigInteger id;
    /**
     * 落地页地址
     * 下载类表示下载地址，deeplink表示跳转地址
     */
    private String url;
    /**
     * 落地页类型，1下载类，2表单类，3deeplink
     */
    private Short page_type;
    /**
     * APP包名
     * 下载类表示下载的应用，deeplink表示跳转的应用
     */
    private String package_name;
    /**
     * 视频地址
     */
    private String video_url;
    /**
     * 封面地址
     */
    private String cover_url;
    /**
     * 标题
     */
    private String title;
    /**
     * 副标题
     */
    private String subtitle;
    /**
     * icon地址
     */
    private String icon_url;
    /**
     * 按钮地址
     */
    private String btn_url;
    /**
     * 结束页信息，null表示无结束页
     */
    private TicketInspireOverPage overPage;
    /**
     * 自定义结束页URL
     */
    private String over_page_url;
    /**
     * 结束页样式类型,1：默认，2：自定义
     */
    private Short over_page_type;
    /**
     * 跳转页面
     */
    private String deep_page;
    /**
     * 跳转应用下载地址
     */
    private String deep_download;
    /**
     * 视频时长，秒
     */
    private Double video_duration;
    /**
     * 来源
     * 1：变现猫
     * 2：第三方
     */
    private Integer source;
    /**
     * 第三方信息
     */
    private TicketInspireOuter outer;

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Short getPage_type() {
        return page_type;
    }

    public void setPage_type(Short page_type) {
        this.page_type = page_type;
    }

    public String getPackage_name() {
        return package_name;
    }

    public void setPackage_name(String package_name) {
        this.package_name = package_name;
    }

    public String getVideo_url() {
        return video_url;
    }

    public void setVideo_url(String video_url) {
        this.video_url = video_url;
    }

    public String getCover_url() {
        return cover_url;
    }

    public void setCover_url(String cover_url) {
        this.cover_url = cover_url;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getIcon_url() {
        return icon_url;
    }

    public void setIcon_url(String icon_url) {
        this.icon_url = icon_url;
    }

    public String getBtn_url() {
        return btn_url;
    }

    public void setBtn_url(String btn_url) {
        this.btn_url = btn_url;
    }

    public TicketInspireOverPage getOverPage() {
        return overPage;
    }

    public void setOverPage(TicketInspireOverPage overPage) {
        this.overPage = overPage;
    }

    public String getOver_page_url() {
        return over_page_url;
    }

    public void setOver_page_url(String over_page_url) {
        this.over_page_url = over_page_url;
    }

    public Short getOver_page_type() {
        return over_page_type;
    }

    public void setOver_page_type(Short over_page_type) {
        this.over_page_type = over_page_type;
    }

    public String getDeep_page() {
        return deep_page;
    }

    public void setDeep_page(String deep_page) {
        this.deep_page = deep_page;
    }

    public String getDeep_download() {
        return deep_download;
    }

    public void setDeep_download(String deep_download) {
        this.deep_download = deep_download;
    }

    public Double getVideo_duration() {
        return video_duration;
    }

    public void setVideo_duration(Double video_duration) {
        this.video_duration = video_duration;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public TicketInspireOuter getOuter() {
        return outer;
    }

    public void setOuter(TicketInspireOuter outer) {
        this.outer = outer;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
