package com.bxm.adsprod.facade.ssp;


import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/10/28 19:29
 */

public final class DirectTicketSspConvert {
    private static Logger logger = LoggerFactory.getLogger(DirectTicketSspConvert.class);

    public static DirectTicketSsp of(Ticket ticket) {

        DirectTicketSsp directTicketSsp = new DirectTicketSsp();
        if (null == ticket) {
            return null;
        }

        TicketAssets assets = ticket.getOfferAssets();

        if (null == assets) {
            if (logger.isWarnEnabled()) {
                logger.warn("ticket {} assets is null", ticket.getId());
            }
            return null;
        }


        String url = ticket.getUrl();
        if (StringUtils.isNotBlank(url) ){
            if (url.indexOf("?")>0){
                url+="&bxm_id="+ticket.getBxmId();
            }else {
                url+="?bxm_id="+ticket.getBxmId();
            }
        }
        directTicketSsp.setUrl(url);
        directTicketSsp.setTicketId(ticket.getId().toString());

        directTicketSsp.setAssetsId(assets.getId().toString());
        directTicketSsp.setImgUrl(assets.getImage());
        directTicketSsp.setIcon(assets.getIcon());
        directTicketSsp.setTitle(assets.getTitle());
        directTicketSsp.setIntro(assets.getIntro());
        directTicketSsp.setButtonTxt(assets.getButtonTxt());
        return directTicketSsp;
    }

    private static String date2String(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }
}
