package com.bxm.adsprod.facade.ticket;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <h3>激励视频第三方信息</h3>
 *
 * @author kerry.jiang
 * @date 2019/8/5 17:55
 */
public class TicketInspireTracker implements Serializable {

    private static final long serialVersionUID = 9132608548480991005L;

    /**
     * 服务器激励回调上报URL
     */
    private List<String> callbackTrackers;
    /**
     * 加载成功监测
     */
    private List<String> loadedTrackers;
    /**
     * 播放错误监测,宏参值为playErrorCodeMap的value值
     * 宏参：__ERROR_CODE__
     */
    private List<String> playErrorTrackers;
    /**
     * 播放错误代码
     * 1：视频地址为空
     * 2：视频缓存失败
     * 3：视频播放失败
     * 4：结束页内容为空
     */
    private Map<String, String> playErrorCodeMap;
    /**
     * 视频曝光
     */
    private List<String> viewTrackers;
    /**
     * 视频点击
     */
    private List<String> clickTrackers;
    /**
     * 开始播放
     */
    private List<String> startTrackers;
    /**
     * 播放1/4
     */
    private List<String> firstTrackers;
    /**
     * 播放一半
     */
    private List<String> midTrackers;
    /**
     * 播放3/4
     */
    private List<String> thirdTrackers;
    /**
     * 播放完成
     */
    private List<String> completeTrackers;
    /**
     * 暂停播放
     */
    private List<String> pauseTrackers;
    /**
     * 继续播放
     */
    private List<String> resumeTrackers;
    /**
     * 视频跳过
     */
    private List<String> skipTrackers;
    /**
     * 关闭视频
     */
    private List<String> closeTrackers;
    /**
     * 静音播放
     */
    private List<String> muteTrackers;
    /**
     * 关闭静音播放
     */
    private List<String> unmuteTrackers;
    /**
     * deeplink调起开始
     */
    private List<String> dpStartTrackers;
    /**
     * deeplink调起成功
     */
    private List<String> dpSuccessTrackers;
    /**
     * deeplink调起失败
     */
    private List<String> dpFailTrackers;

    public List<String> getCallbackTrackers() {
        return callbackTrackers;
    }

    public void setCallbackTrackers(List<String> callbackTrackers) {
        this.callbackTrackers = callbackTrackers;
    }

    public List<String> getLoadedTrackers() {
        return loadedTrackers;
    }

    public void setLoadedTrackers(List<String> loadedTrackers) {
        this.loadedTrackers = loadedTrackers;
    }

    public List<String> getPlayErrorTrackers() {
        return playErrorTrackers;
    }

    public void setPlayErrorTrackers(List<String> playErrorTrackers) {
        this.playErrorTrackers = playErrorTrackers;
    }

    public Map<String, String> getPlayErrorCodeMap() {
        return playErrorCodeMap;
    }

    public void setPlayErrorCodeMap(Map<String, String> playErrorCodeMap) {
        this.playErrorCodeMap = playErrorCodeMap;
    }

    public List<String> getViewTrackers() {
        return viewTrackers;
    }

    public void setViewTrackers(List<String> viewTrackers) {
        this.viewTrackers = viewTrackers;
    }

    public List<String> getClickTrackers() {
        return clickTrackers;
    }

    public void setClickTrackers(List<String> clickTrackers) {
        this.clickTrackers = clickTrackers;
    }

    public List<String> getStartTrackers() {
        return startTrackers;
    }

    public void setStartTrackers(List<String> startTrackers) {
        this.startTrackers = startTrackers;
    }

    public List<String> getFirstTrackers() {
        return firstTrackers;
    }

    public void setFirstTrackers(List<String> firstTrackers) {
        this.firstTrackers = firstTrackers;
    }

    public List<String> getMidTrackers() {
        return midTrackers;
    }

    public void setMidTrackers(List<String> midTrackers) {
        this.midTrackers = midTrackers;
    }

    public List<String> getThirdTrackers() {
        return thirdTrackers;
    }

    public void setThirdTrackers(List<String> thirdTrackers) {
        this.thirdTrackers = thirdTrackers;
    }

    public List<String> getCompleteTrackers() {
        return completeTrackers;
    }

    public void setCompleteTrackers(List<String> completeTrackers) {
        this.completeTrackers = completeTrackers;
    }

    public List<String> getPauseTrackers() {
        return pauseTrackers;
    }

    public void setPauseTrackers(List<String> pauseTrackers) {
        this.pauseTrackers = pauseTrackers;
    }

    public List<String> getResumeTrackers() {
        return resumeTrackers;
    }

    public void setResumeTrackers(List<String> resumeTrackers) {
        this.resumeTrackers = resumeTrackers;
    }

    public List<String> getSkipTrackers() {
        return skipTrackers;
    }

    public void setSkipTrackers(List<String> skipTrackers) {
        this.skipTrackers = skipTrackers;
    }

    public List<String> getCloseTrackers() {
        return closeTrackers;
    }

    public void setCloseTrackers(List<String> closeTrackers) {
        this.closeTrackers = closeTrackers;
    }

    public List<String> getMuteTrackers() {
        return muteTrackers;
    }

    public void setMuteTrackers(List<String> muteTrackers) {
        this.muteTrackers = muteTrackers;
    }

    public List<String> getUnmuteTrackers() {
        return unmuteTrackers;
    }

    public void setUnmuteTrackers(List<String> unmuteTrackers) {
        this.unmuteTrackers = unmuteTrackers;
    }

    public List<String> getDpStartTrackers() {
        return dpStartTrackers;
    }

    public void setDpStartTrackers(List<String> dpStartTrackers) {
        this.dpStartTrackers = dpStartTrackers;
    }

    public List<String> getDpSuccessTrackers() {
        return dpSuccessTrackers;
    }

    public void setDpSuccessTrackers(List<String> dpSuccessTrackers) {
        this.dpSuccessTrackers = dpSuccessTrackers;
    }

    public List<String> getDpFailTrackers() {
        return dpFailTrackers;
    }

    public void setDpFailTrackers(List<String> dpFailTrackers) {
        this.dpFailTrackers = dpFailTrackers;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
