package com.bxm.adsprod.facade.ticket;

import com.bxm.adsprod.facade.rules.Rule;
import com.bxm.adsprod.facade.ticket.adx.TicketAdx;
import com.bxm.adsprod.facade.ticket.adx.TicketAdxCreative;
import com.bxm.adsprod.facade.ticket.inspirevideo.TicketInspireVideo;
import com.bxm.adsprod.facade.ticket.inspirevideo.TicketInspireVideoCreative;

import java.util.List;

/**
 * <h3>包含规则的广告券信息</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/28
 */
public class TicketOfRules extends Ticket {

    private static final long serialVersionUID = -5375015030248563075L;

    /**
     * 该广告券配置的票券码基本信息
     */
    private TicketCouponsInfo ticketCouponsInfo;
    /**
     * 该广告券配置的票券码素材列表
     */
    private List<TicketAssetsCoupons> assetsCoupons;
    /**
     * adx 配置信息
     */
    private TicketAdx ticketAdx;
    /**
     * adx 素材列表
     */
    private List<TicketAdxCreative> ticketAdxCreatives;
    /**
     * 激励视频 配置信息
     */
    private TicketInspireVideo ticketInspireVideo;
    /**
     * 激励视频 素材列表
     */
    private List<TicketInspireVideoCreative> ticketInspireVideoCreatives;
    /**
     * 该广告券配置的素材列表
     */
    private List<TicketAssets> assets;
    /**
     * 广告券地域规则
     */
    private Rule region;
    /**
     * 广告券广告位规则
     */
    private Rule position;
    /**
     * 广告券时间段规则
     */
    private Rule timeline;
    /**
     * 广告券频次规则
     */
    private Rule times;
    /**
     * 广告位组频次规则（流量包）
     */
    private Rule positionGroup;
    /**
     * 广告券组地域定向指定ip库规则
     */
    private Rule ipLib;
    /**
     * 人群包定向（弃用）
     */
    private Rule crowdPackage;
    /**
     * ADX券包
     */
    private Rule ticketPackage;
    /**
     * 已安装包名定向
     */
    private Rule appPackage;
    /**
     * 人群包定向
     */
    private TicketCrowd ticketCrowd;

    public Rule getTicketPackage() {
        return ticketPackage;
    }

    public void setTicketPackage(Rule ticketPackage) {
        this.ticketPackage = ticketPackage;
    }

    public List<TicketInspireVideoCreative> getTicketInspireVideoCreatives() {
        return ticketInspireVideoCreatives;
    }

    public void setTicketInspireVideoCreatives(List<TicketInspireVideoCreative> ticketInspireVideoCreatives) {
        this.ticketInspireVideoCreatives = ticketInspireVideoCreatives;
    }

    public TicketInspireVideo getTicketInspireVideo() {
        return ticketInspireVideo;
    }

    public void setTicketInspireVideo(TicketInspireVideo ticketInspireVideo) {
        this.ticketInspireVideo = ticketInspireVideo;
    }

    public TicketAdx getTicketAdx() {
        return ticketAdx;
    }

    public void setTicketAdx(TicketAdx ticketAdx) {
        this.ticketAdx = ticketAdx;
    }

    public List<TicketAdxCreative> getTicketAdxCreatives() {
        return ticketAdxCreatives;
    }

    public void setTicketAdxCreatives(List<TicketAdxCreative> ticketAdxCreatives) {
        this.ticketAdxCreatives = ticketAdxCreatives;
    }

    public TicketCouponsInfo getTicketCouponsInfo() {
        return ticketCouponsInfo;
    }

    public void setTicketCouponsInfo(TicketCouponsInfo ticketCouponsInfo) {
        this.ticketCouponsInfo = ticketCouponsInfo;
    }

    public List<TicketAssetsCoupons> getAssetsCoupons() {
        return assetsCoupons;
    }

    public void setAssetsCoupons(List<TicketAssetsCoupons> assetsCoupons) {
        this.assetsCoupons = assetsCoupons;
    }

    public Rule getIpLib() {
		return ipLib;
	}

	public void setIpLib(Rule ipLib) {
		this.ipLib = ipLib;
	}

	public List<TicketAssets> getAssets() {
        return assets;
    }

    public void setAssets(List<TicketAssets> assets) {
        this.assets = assets;
    }

    public Rule getRegion() {
        return region;
    }

    public void setRegion(Rule region) {
        this.region = region;
    }

    public Rule getPosition() {
        return position;
    }

    public void setPosition(Rule position) {
        this.position = position;
    }

    public Rule getTimeline() {
        return timeline;
    }

    public void setTimeline(Rule timeline) {
        this.timeline = timeline;
    }

    public Rule getTimes() {
        return times;
    }

    public void setTimes(Rule times) {
        this.times = times;
    }

    public Rule getPositionGroup() {
        return positionGroup;
    }

    public void setPositionGroup(Rule positionGroup) {
        this.positionGroup = positionGroup;
    }

    public Rule getCrowdPackage() {
        return crowdPackage;
    }

    public void setCrowdPackage(Rule crowdPackage) {
        this.crowdPackage = crowdPackage;
    }

    public Rule getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(Rule appPackage) {
        this.appPackage = appPackage;
    }

    public TicketCrowd getTicketCrowd() {
        return ticketCrowd;
    }

    public void setTicketCrowd(TicketCrowd ticketCrowd) {
        this.ticketCrowd = ticketCrowd;
    }
}
