package com.bxm.adsprod.facade.ssp;

import com.bxm.warcar.validate.annotation.ValidateImeiOrIdfa;
import com.bxm.warcar.validate.annotation.ValidateNotNull;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 激励视频请求对象<br/>
 *
 * @author kerry.jiang
 * @date 2020/10/9 15:14
 */
public class TicketInspireSspRequest implements Serializable {

    private static final long serialVersionUID = 1132577199900938728L;
    /**
     * 广告请求id
     */
    @ValidateNotNull
    private String requestId;
    /**
     * 广告位ID
     */
    @ValidateNotNull
    private String position;
    /**
     * SSP广告位ID
     */
    private String sspPositionId;
    /**
     * app信息
     */
    @ValidateNotNull
    private AppInfo app;
    /**
     * 设备信息
     */
    @ValidateNotNull
    private DeviceInfo device;
    /**
     * 请求来源
     */
    private String referer;
    /**
     * 用户当前请求的域
     */
    private String origin;
    /**
     * User agent
     */
    private String ua;
    /**
     * mac地址
     */
    private String mac;

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getSspPositionId() {
        return sspPositionId;
    }

    public void setSspPositionId(String sspPositionId) {
        this.sspPositionId = sspPositionId;
    }

    public AppInfo getApp() {
        return app;
    }

    public void setApp(AppInfo app) {
        this.app = app;
    }

    public DeviceInfo getDevice() {
        return device;
    }

    public void setDevice(DeviceInfo device) {
        this.device = device;
    }

    public String getReferer() {
        return referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /**
     * app信息
     */
    public static class AppInfo implements Serializable {

        private static final long serialVersionUID = 1132577199900938728L;
        /**
         * 应用名
         */
        private String name;
        /**
         * 应用唯一标识，安卓为包名，IOS为number ID
         */
        private String bundle;
        /**
         * APP类型
         */
        private String car;
        /**
         * App对应的域名，例如mygame.foo.com
         */
        private String domain;
        /**
         * App在应用商店的下载链接
         */
        private String storeUrl;
        /**
         * 保留字段
         */
        private String ext;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBundle() {
            return bundle;
        }

        public void setBundle(String bundle) {
            this.bundle = bundle;
        }

        public String getCar() {
            return car;
        }

        public void setCar(String car) {
            this.car = car;
        }

        public String getDomain() {
            return domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getStoreUrl() {
            return storeUrl;
        }

        public void setStoreUrl(String storeUrl) {
            this.storeUrl = storeUrl;
        }

        public String getExt() {
            return ext;
        }

        public void setExt(String ext) {
            this.ext = ext;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    /**
     * 设备信息
     */
    public static class DeviceInfo implements Serializable {

        private static final long serialVersionUID = 1132577199900938728L;
        /**
         * 用户真实公网IP，如 12.34.56.78
         */
        @ValidateNotNull
        private String ip;
        /**
         * 操作系统，1：安卓 2：IOS [3：windows phone(去除)] 4：未知
         */
        @ValidateNotNull
        private Integer os;
        /**
         * 系统版本号，如：10.0.0
         */
        private String osv;
        /**
         * imei
         */
        @ValidateImeiOrIdfa
        private String imei;
        /**
         * imei md5
         */
        private String imeimd5;
        /**
         * 安卓id
         */
        private String anid;
        /**
         * 安卓id md5
         */
        private String anidmd5;
        /**
         * 安全联盟定义的用户唯一标识OAID
         */
        private String oaid;
        /**
         * idfa
         */
        @ValidateImeiOrIdfa
        private String idfa;
        /**
         * idfa md5
         */
        private String idfamd5;
        /**
         * 设备id
         */
        private String deviceid;
        /**
         * 保留字段
         */
        private String ext;

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Integer getOs() {
            return os;
        }

        public void setOs(Integer os) {
            this.os = os;
        }

        public String getOsv() {
            return osv;
        }

        public void setOsv(String osv) {
            this.osv = osv;
        }

        public String getImei() {
            return imei;
        }

        public void setImei(String imei) {
            this.imei = imei;
        }

        public String getImeimd5() {
            return imeimd5;
        }

        public void setImeimd5(String imeimd5) {
            this.imeimd5 = imeimd5;
        }

        public String getAnid() {
            return anid;
        }

        public void setAnid(String anid) {
            this.anid = anid;
        }

        public String getAnidmd5() {
            return anidmd5;
        }

        public void setAnidmd5(String anidmd5) {
            this.anidmd5 = anidmd5;
        }

        public String getOaid() {
            return oaid;
        }

        public void setOaid(String oaid) {
            this.oaid = oaid;
        }

        public String getIdfa() {
            return idfa;
        }

        public void setIdfa(String idfa) {
            this.idfa = idfa;
        }

        public String getIdfamd5() {
            return idfamd5;
        }

        public void setIdfamd5(String idfamd5) {
            this.idfamd5 = idfamd5;
        }

        public String getDeviceid() {
            return deviceid;
        }

        public void setDeviceid(String deviceid) {
            this.deviceid = deviceid;
        }

        public String getExt() {
            return ext;
        }

        public void setExt(String ext) {
            this.ext = ext;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}
