package com.bxm.adsprod.facade.ticket;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

import com.bxm.warcar.utils.Constants;

/**
 * @author allen
 * @date 2017-12-05
 */
public class TicketAssets implements Serializable {
    private static final long serialVersionUID = 4368329874159718574L;

    public static final int VARS_NONE = 0;
    public static final int VARS_PROVINCE = 1;
    public static final int VARS_CITY = 2;

    //券类型为【推送券】互动广告运营后台素材的字段对应关系
    //button_txt  app包名
    //intro       广告内容
    //title       广告标题
    //image       图片
    //icon        icon

    private BigInteger id;
    private String name;
    private Byte vars;
    private String content;
    private String image;
    private String intro;
    private String buttonTxt;
    private Integer   clickThreshold;
    private String title;
    private String icon;
    /**
     * 状态
     * @see com.bxm.warcar.utils.Constants#YES
     * @see com.bxm.warcar.utils.Constants#NO
     */
    private Byte status;

    /**
     * 素材是否屏蔽弹窗
     */
    private String isShieldPopup;

    /**
     * 点击监测地址
     */
    private List<String> clktrackers;
    /**
     * 曝光监测地址
     */
    private List<String> imptrackers;

    public List<String> getClktrackers() {
        return clktrackers;
    }

    public void setClktrackers(List<String> clktrackers) {
        this.clktrackers = clktrackers;
    }

    public List<String> getImptrackers() {
        return imptrackers;
    }

    public void setImptrackers(List<String> imptrackers) {
        this.imptrackers = imptrackers;
    }


    public boolean isAvailable() {
        return null != status && status.byteValue() == Constants.YES;
    }

    public BigInteger getId() {
        return id;
    }

    public void setId(BigInteger id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getIntro() {
        return intro;
    }

    public void setIntro(String intro) {
        this.intro = intro;
    }

    public String getButtonTxt() {
        return buttonTxt;
    }

    public void setButtonTxt(String buttonTxt) {
        this.buttonTxt = buttonTxt;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Byte getVars() {
        return vars;
    }

    public void setVars(Byte vars) {
        this.vars = vars;
    }

    public Integer getClickThreshold() {
        return clickThreshold;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIsShieldPopup() {
        return isShieldPopup;
    }

    public void setIsShieldPopup(String isShieldPopup) {
        this.isShieldPopup = isShieldPopup;
    }

    public void setClickThreshold(Integer clickThreshold) {
        this.clickThreshold = clickThreshold;
    }
}
